/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade.linetypeupgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class LineTypeUpgradeService
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(LineTypeUpgradeService.class);
    private static final int batchSizeNum = 1000;
    private static final Long BIZTYPE_MATPUR = 422857170485263360L;
    private static final Long LINETYPE_EXPENSEITEM = 1194156052984154112L;

    private static Map<String, Long> getMaterialTypeAndAttributeMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("1", 1194029484878120960L);
        map.put("7", 1194029878949760000L);
        map.put("8", 1194030110357899264L);
        map.put("9", 1194029708862343168L);
        map.put("2", 1194029484878120960L);
        map.put("3", 1194029484878120960L);
        map.put("4", 1194029484878120960L);
        map.put("5", 1194029484878120960L);
        return map;
    }

    UpgradeResult doUpdate(String dbRouteKey, String t_mainTable, String t_materialFieldKey, String t_material, String t_bizTypeKey, String t_lineTypeTable, String isMaterialMasterid) {
        UpgradeResult result = new UpgradeResult();
        if (StringUtils.isBlank((CharSequence)dbRouteKey) || StringUtils.isBlank((CharSequence)t_mainTable) || StringUtils.isBlank((CharSequence)t_materialFieldKey) || StringUtils.isBlank((CharSequence)t_bizTypeKey) || StringUtils.isBlank((CharSequence)t_material) || StringUtils.isBlank((CharSequence)t_lineTypeTable) || StringUtils.isBlank((CharSequence)isMaterialMasterid)) {
            throw new KDBizException("LineTypeUpgradeService execution failed,Please check and try again.");
        }
        String serviceName = t_mainTable + this.getClass().getName();
        logger.info(serviceName + " \u6267\u884c\u670d\u52a1\u5165\u53c2\uff1aDBRoute " + dbRouteKey + " t_mainTable " + t_mainTable + " t_materialFieldKey " + t_materialFieldKey + " t_bizTypeKey " + t_bizTypeKey + " t_lineTypeTable " + t_lineTypeTable + " isMaterialMasterid " + isMaterialMasterid + " t_material" + t_material);
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        boolean isMasterId = false;
        if (isMaterialMasterid != null && isMaterialMasterid.trim().length() > 0) {
            isMasterId = Boolean.parseBoolean(isMaterialMasterid.trim());
        }
        Map<Long, BizTypeParameter> bizTypeParameterMap = this.buildBizTypeParam(serviceName);
        DataSet billEntryRows = DB.queryDataSet((String)serviceName, (DBRoute)dbRoute, (String)this.getQueryBillSql(t_bizTypeKey, t_materialFieldKey, t_mainTable, t_lineTypeTable));
        HashMap<Long, Map<String, Long>> entryIDAndBizTypeMatID = new HashMap<Long, Map<String, Long>>(16);
        HashSet<Long> materialMasteridSet = new HashSet<Long>(16);
        int rowCount = 0;
        for (Row row : billEntryRows) {
            ++rowCount;
            Long material = row.getLong("MATERIAL");
            Long entryid = row.getLong("ENTRYID");
            Long bizType = row.getLong("BIZTYPE");
            HashMap<String, Long> map = new HashMap<String, Long>(5);
            map.put("material", material);
            map.put("biztype", bizType);
            entryIDAndBizTypeMatID.put(entryid, map);
            materialMasteridSet.add(material);
            if (rowCount < 1000) continue;
            List<Object[]> entryIdAndLineTypeID = this.getEntryIdAndLineTypeID(serviceName, isMasterId, t_mainTable, t_material, entryIDAndBizTypeMatID, materialMasteridSet, bizTypeParameterMap);
            if (entryIdAndLineTypeID.size() > 0) {
                result = this.updateBillLineType(result, t_lineTypeTable, entryIdAndLineTypeID);
            }
            if (!result.isSuccess()) {
                return result;
            }
            entryIdAndLineTypeID.clear();
            entryIDAndBizTypeMatID.clear();
            materialMasteridSet.clear();
            rowCount = 0;
        }
        if (rowCount > 0) {
            List<Object[]> entryIdAndLineTypeID = this.getEntryIdAndLineTypeID(serviceName, isMasterId, t_mainTable, t_material, entryIDAndBizTypeMatID, materialMasteridSet, bizTypeParameterMap);
            if (entryIdAndLineTypeID.size() > 0) {
                result = this.updateBillLineType(result, t_lineTypeTable, entryIdAndLineTypeID);
            }
            entryIdAndLineTypeID.clear();
            entryIDAndBizTypeMatID.clear();
            materialMasteridSet.clear();
        }
        return result;
    }

    private List<Object[]> getEntryIdAndLineTypeID(String serviceName, boolean isMasterId, String mainTable, String t_material, Map<Long, Map<String, Long>> entryIDAndBizTypeMatID, Set<Long> materialSet, Map<Long, BizTypeParameter> bizTypeParameterMap) {
        HashMap<Long, String> materialIDAnMaterialType = new HashMap<Long, String>(16);
        String queryMaterialSql = this.getQueryMaterialSql(materialSet, t_material, isMasterId);
        DataSet materialRows = DB.queryDataSet((String)"queryMaterial", (DBRoute)new DBRoute("base"), (String)queryMaterialSql);
        for (Row row : materialRows) {
            Long material = row.getLong("MATERIAL");
            String materialType = row.getString("MATERIALTYPE");
            materialIDAnMaterialType.put(material, materialType);
        }
        materialSet.clear();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Map<String, Long>> entry : entryIDAndBizTypeMatID.entrySet()) {
            Long lineTypeId;
            String materialType;
            Long entryId = entry.getKey();
            Map<String, Long> map = entry.getValue();
            Long biztype = map.get("biztype");
            Long material = map.get("material");
            BizTypeParameter bizTypeParameter = bizTypeParameterMap.get(biztype);
            if (bizTypeParameter == null || StringUtils.isBlank((CharSequence)(materialType = (String)materialIDAnMaterialType.get(material))) || (lineTypeId = this.getLineTypeID(mainTable, biztype, materialType, bizTypeParameter)) == null) continue;
            ArrayList<Long> param = new ArrayList<Long>(5);
            param.add(lineTypeId);
            param.add(entryId);
            paramList.add(param.toArray());
        }
        return paramList;
    }

    private UpgradeResult updateBillLineType(UpgradeResult result, String t_lineType, List<Object[]> paramList) {
        StringBuilder sql_update = new StringBuilder(" UPDATE ").append(t_lineType).append(" SET FLINETYPEID =? WHERE FENTRYID =? AND FLINETYPEID = 0");
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql_update.toString(), paramList);
                paramList.clear();
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                String err = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(err);
                result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                UpgradeResult upgradeResult = result;
                if (h != null) {
                    if (var6_6 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        return result;
    }

    private Long getLineTypeID(String mainTable, Long biztype, String materialType, BizTypeParameter bizTypeParameter) {
        Map<Long, Long> attrAndLineTypeMap;
        Long deflineType;
        if (materialType == null) {
            return null;
        }
        Long defAttr = bizTypeParameter.getDefaultAttr();
        Long specialLineType = this.specialDeal(mainTable, biztype, defAttr, deflineType = bizTypeParameter.getDefaultLineType(), attrAndLineTypeMap = bizTypeParameter.getAttrAndLineTypeMap(), materialType);
        if (specialLineType != null) {
            return specialLineType;
        }
        if (attrAndLineTypeMap == null) {
            return null;
        }
        return attrAndLineTypeMap.get(LineTypeUpgradeService.getMaterialTypeAndAttributeMap().get(materialType));
    }

    private Long specialDeal(String mainTable, Long biztype, Long defAttr, Long deflineType, Map<Long, Long> attrAndLineTypeMap, String materialType) {
        if (("t_pm_purapplybill".equals(mainTable) || "t_pm_purorderbill".equals(mainTable) || "t_pm_xpurorderbill".equals(mainTable)) && BIZTYPE_MATPUR.equals(biztype) && "7".equals(materialType)) {
            return LINETYPE_EXPENSEITEM;
        }
        return null;
    }

    private Map<Long, BizTypeParameter> buildBizTypeParam(String serviceName) {
        HashMap<Long, BizTypeParameter> allBizTypeInfo = new HashMap<Long, BizTypeParameter>(16);
        String queryBizTypeSql = this.getQueryBizTypeSql();
        DataSet bizTypeRows = DB.queryDataSet((String)(serviceName + "_queryBizType"), (DBRoute)new DBRoute("base"), (String)queryBizTypeSql);
        for (Row row : bizTypeRows) {
            Long linetypeid = row.getLong("LINETYPEID");
            Long biztypeid = row.getLong("BIZTYPEID");
            Long serviceattribute = row.getLong("SERVICEATTRIBUTEID");
            Boolean isdefault = row.getBoolean("ISDEFAULT");
            if (linetypeid == null || biztypeid == null || serviceattribute == null || isdefault == null) continue;
            BizTypeParameter bizTypeParameter = (BizTypeParameter)allBizTypeInfo.get(biztypeid);
            if (bizTypeParameter == null) {
                bizTypeParameter = new BizTypeParameter();
                if (isdefault.booleanValue()) {
                    bizTypeParameter.setDefaultLineType(linetypeid);
                    bizTypeParameter.setDefaultAttr(serviceattribute);
                }
                HashMap<Long, Long> map = new HashMap<Long, Long>(16);
                map.put(serviceattribute, linetypeid);
                bizTypeParameter.setAttrAndLineTypeMap(map);
            } else {
                Map<Long, Long> attrAndLineTypeMap;
                if (isdefault.booleanValue() && (bizTypeParameter.getDefaultAttr() == null || bizTypeParameter.getDefaultLineType() == null)) {
                    bizTypeParameter.setDefaultLineType(linetypeid);
                    bizTypeParameter.setDefaultAttr(serviceattribute);
                }
                if ((attrAndLineTypeMap = bizTypeParameter.getAttrAndLineTypeMap()) == null) {
                    attrAndLineTypeMap = new HashMap<Long, Long>(16);
                }
                attrAndLineTypeMap.put(serviceattribute, linetypeid);
                bizTypeParameter.setAttrAndLineTypeMap(attrAndLineTypeMap);
            }
            allBizTypeInfo.put(biztypeid, bizTypeParameter);
        }
        logger.info(((Object)allBizTypeInfo).toString());
        return allBizTypeInfo;
    }

    private String getQueryBillSql(String t_bizTypeKey, String t_materialFieldKey, String mainTable, String t_lineType) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT T1.").append(t_bizTypeKey).append(" BIZTYPE ,T1.FID,T2.").append(t_materialFieldKey).append("  MATERIAL ,T2.FENTRYID  ENTRYID FROM ").append(mainTable).append(" T1 LEFT JOIN ").append(t_lineType).append(" T2 ON T1.FID = T2.FID WHERE T2.FLINETYPEID = 0 ");
        return sb.toString();
    }

    private String getQueryBizTypeSql() {
        return "SELECT T1.FID AS BIZTYPEID ,T1.FISDEFAULT AS ISDEFAULT,T1.FLINETYPEID AS LINETYPEID,T2.FSERVICEATTRIBUTE  AS SERVICEATTRIBUTEID FROM (SELECT FID  ,FISDEFAULT ,FLINETYPEID  FROM T_BD_LINETYPEENTRY WHERE FLINETYPEID <>0)T1 LEFT JOIN T_BD_LINETYPE T2 ON T1.FLINETYPEID = T2.FID WHERE T2.FCONTROLCRITERION ='0' ;";
    }

    private String getQueryMaterialSql(Set<Long> materialSet, String t_material, boolean isMasterId) {
        StringBuilder materialIds = new StringBuilder();
        materialSet.forEach(materialId -> materialIds.append(materialId).append(","));
        String matIds = materialIds.substring(0, materialIds.lastIndexOf(","));
        String queryMaterialSql = null;
        queryMaterialSql = isMasterId ? "SELECT FID MATERIAL,FMATERIALTYPE MATERIALTYPE FROM  T_BD_MATERIAL_S WHERE FID IN ( " + matIds + ") " : "SELECT T1.FID MATERIAL,T2.FMATERIALTYPE MATERIALTYPE FROM  (SELECT FMASTERID,FID FROM " + t_material + " WHERE FID IN (" + matIds + ")) T1 LEFT JOIN T_BD_MATERIAL_S T2 ON T1.FMASTERID = T2.FID ";
        return queryMaterialSql;
    }

    static class BizTypeParameter {
        private Long defaultAttr;
        private Long defaultLineType;
        private Map<Long, Long> attrAndLineTypeMap;

        BizTypeParameter() {
        }

        Long getDefaultAttr() {
            return this.defaultAttr;
        }

        Long getDefaultLineType() {
            return this.defaultLineType;
        }

        Map<Long, Long> getAttrAndLineTypeMap() {
            return this.attrAndLineTypeMap;
        }

        void setAttrAndLineTypeMap(Map<Long, Long> attrAndLineTypeMap) {
            this.attrAndLineTypeMap = attrAndLineTypeMap;
        }

        void setDefaultAttr(Long defaultAttr) {
            this.defaultAttr = defaultAttr;
        }

        void setDefaultLineType(Long defaultLineType) {
            this.defaultLineType = defaultLineType;
        }

        public String toString() {
            return "BizTypeParameter{defaultAttr=" + this.defaultAttr + ", defaultLineType=" + this.defaultLineType + ", attrAndLineTypeMap=" + this.attrAndLineTypeMap + '}';
        }
    }
}

