/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade.verticalmerge;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public abstract class BaseMergeUpgradeServiceImpl
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(BaseMergeUpgradeServiceImpl.class);
    public static int BATCH_EXEC_NUMS = 2500000;
    private static int BATCH_INTERVAL = 3;
    private static int THREAD_NUMS = 8;
    private static int MAX_ERROR_TIMES = 3;
    protected UpgradeResult result;
    protected DBRoute route;
    protected String servicename;

    protected boolean isIgnoreExecUpgrade(String switchname) {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)BaseMergeUpgradeServiceImpl.class.getName(), (DBRoute)this.route, (String)switchSql, (Object[])new Object[]{switchname});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    protected Map<Integer, Object[]> getExecSqlParams(String splitTablename, String idcol) {
        String countSql = "select count(1) as count,min(" + idcol + ") as minid,max(" + idcol + ") as maxid from " + splitTablename;
        long count = 0L;
        long minid = 0L;
        long maxid = 0L;
        try (DataSet countSet = DB.queryDataSet((String)BaseMergeUpgradeServiceImpl.class.getName(), (DBRoute)this.route, (String)countSql);){
            for (Row row : countSet) {
                count = row.getLong("count");
                if (count <= 0L) continue;
                minid = row.getLong("minid");
                maxid = row.getLong("maxid");
                break;
            }
        }
        if (count <= 0L) {
            return Collections.emptyMap();
        }
        if (count <= (long)BATCH_EXEC_NUMS) {
            return Collections.singletonMap(1, new Object[]{minid, maxid + 1L});
        }
        int batchs = new BigDecimal(count).divide(new BigDecimal(BATCH_EXEC_NUMS), RoundingMode.CEILING).intValue();
        HashMap<Integer, Object[]> params = new HashMap<Integer, Object[]>(batchs);
        HashMap<Integer, Object[]> paramsReorder = new HashMap<Integer, Object[]>(batchs);
        long idFrom = minid;
        long idTo = 0L;
        String nextIdSql = "select top 1," + BATCH_EXEC_NUMS + " " + idcol + " as id from " + splitTablename + " where " + idcol + " >= ?" + " order by " + idcol;
        for (int i = 1; i <= batchs; ++i) {
            Object[] param2 = new Object[2];
            if (i == batchs) {
                idTo = maxid + 1L;
            } else {
                try (DataSet nextIdtoSet = this.getNextIdtoSet(idFrom, nextIdSql);){
                    if (nextIdtoSet.hasNext()) {
                        Row row = nextIdtoSet.next();
                        idTo = row.getLong("id");
                    }
                }
            }
            param2[0] = idFrom;
            param2[1] = idTo;
            params.put(i, param2);
            idFrom = idTo;
        }
        StringBuilder paramBuilder = new StringBuilder(this.servicename).append(':');
        params.values().forEach(param -> paramBuilder.append(Arrays.toString(param)));
        logger.info(paramBuilder.toString());
        int index = 1;
        for (int i = 1; i <= BATCH_INTERVAL; ++i) {
            for (int j = i; j <= batchs; j += BATCH_INTERVAL) {
                Object[] param3 = (Object[])params.get(j);
                paramsReorder.put(index, param3);
                ++index;
            }
        }
        return paramsReorder;
    }

    private DataSet getNextIdtoSet(long idFrom, String nextIdSql) {
        return DB.queryDataSet((String)BaseMergeUpgradeServiceImpl.class.getName(), (DBRoute)this.route, (String)nextIdSql, (Object[])new Object[]{idFrom});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSplitSql(String splitUpdateSql, Map<Integer, Object[]> params) {
        int size = params.size();
        try (ThreadPool pool = null;){
            String tenantId = "Default";
            RequestContextInfo rci = RequestContextInfo.get();
            if (rci != null) {
                tenantId = rci.getTenantId();
            }
            String poolname = tenantId + '.' + this.servicename;
            pool = ThreadPools.newCachedThreadPool((String)poolname, (int)THREAD_NUMS, (int)(THREAD_NUMS * 2));
            HashSet<Integer> execIndexes = new HashSet<Integer>(THREAD_NUMS);
            int errtimes = 0;
            while (!params.isEmpty()) {
                if (errtimes >= MAX_ERROR_TIMES) {
                    StringBuilder errlogBuilder = new StringBuilder(this.servicename).append(" error:");
                    params.values().forEach(param -> errlogBuilder.append(Arrays.toString(param)));
                    errlogBuilder.append(splitUpdateSql);
                    String errlog = errlogBuilder.toString();
                    this.result.setLog(errlog);
                    this.result.setErrorInfo(errlog);
                    boolean bl = false;
                    return bl;
                }
                execIndexes.clear();
                int firstIndex = 0;
                for (int i = 1; i <= 2; ++i) {
                    for (int j = 1; j <= size && (i != 2 || j < firstIndex); ++j) {
                        if (params.containsKey(j)) {
                            if (firstIndex == 0) {
                                firstIndex = j;
                            }
                            execIndexes.add(j);
                        }
                        if (execIndexes.size() != THREAD_NUMS) continue;
                        this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                        execIndexes.clear();
                        firstIndex = 0;
                    }
                }
                if (execIndexes.size() > 0) {
                    this.concurrentHandleSql(pool, splitUpdateSql, params, execIndexes);
                }
                ++errtimes;
            }
            boolean bl = true;
            return bl;
        }
    }

    private void concurrentHandleSql(ThreadPool pool, final String sql, Map<Integer, Object[]> params, Set<Integer> execIndexes) {
        HashMap<Integer, Future> execFutureMap = new HashMap<Integer, Future>(THREAD_NUMS);
        Iterator<Object> iterator = execIndexes.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            final Object[] param = params.get(n);
            Future future = pool.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    StringBuilder execBuilder = new StringBuilder(BaseMergeUpgradeServiceImpl.this.servicename).append(" exec:").append(Arrays.toString(param)).append(sql);
                    logger.info(execBuilder.toString());
                    DB.execute((DBRoute)BaseMergeUpgradeServiceImpl.this.route, (String)sql, (Object[])param);
                    return true;
                }
            });
            execFutureMap.put(n, future);
        }
        for (Map.Entry entry : execFutureMap.entrySet()) {
            int index = (Integer)entry.getKey();
            try {
                if (!((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                params.remove(index);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error((Throwable)e);
            }
        }
    }

    protected void updateSwitch(String switchname) {
        String updateSql = "update t_im_invdbparam set fvalue = '1' where fkey = ?";
        DB.execute((DBRoute)this.route, (String)updateSql, (Object[])new Object[]{switchname});
    }
}

