/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action;

import java.util.ArrayList;
import java.util.List;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.action.impl.BillOperExecuteAction;
import kd.scmc.ism.business.action.impl.BillOperRedoAction;
import kd.scmc.ism.business.action.impl.BizFlowExecuteAction;
import kd.scmc.ism.business.action.impl.GenerateSettleBillAction;
import kd.scmc.ism.business.action.impl.GeneratedBillRecalAction;
import kd.scmc.ism.business.action.impl.check.SettleJudgeCheckAction;
import kd.scmc.ism.business.action.impl.match.BuildSelfCoupleBillAction;
import kd.scmc.ism.business.action.impl.match.BuildSrcBillModelAction;
import kd.scmc.ism.business.action.impl.match.DynaObjJudgeMatchAction;
import kd.scmc.ism.business.action.impl.match.JudgeAndBizDirectAction;
import kd.scmc.ism.business.action.impl.match.RelationMatchAction;
import kd.scmc.ism.business.action.impl.param.SettleParamMatchAction;
import kd.scmc.ism.business.action.impl.param.SettleParamValueSetAction;
import kd.scmc.ism.business.action.impl.pricing.CoupleBillPricingAction;
import kd.scmc.ism.business.action.impl.pricing.PathPricingAction;
import kd.scmc.ism.business.action.impl.pricing.PriceRuleMatchAction;
import kd.scmc.ism.business.action.impl.pricing.PricingValueWriteBackAction;
import kd.scmc.ism.business.action.impl.pricing.RedBillPricingAction;
import kd.scmc.ism.business.action.impl.pricing.SettlePricingAction;
import kd.scmc.ism.business.action.impl.pricing.ValueWriteBackAction;
import kd.scmc.ism.business.action.impl.vali.SettleJudgeAction;
import kd.scmc.ism.business.action.impl.vali.ValidateSettleAction;

public class SettleActionFactory {
    public static List<AbstractSettleAction> buildPreMatchActions() {
        ArrayList<AbstractSettleAction> actions = new ArrayList<AbstractSettleAction>(16);
        actions.add(new JudgeAndBizDirectAction());
        actions.add(new BuildSrcBillModelAction());
        actions.add(new RelationMatchAction());
        actions.add(new SettleParamMatchAction());
        return actions;
    }

    public static List<AbstractSettleAction> getPriceActions() {
        ArrayList<AbstractSettleAction> actions = new ArrayList<AbstractSettleAction>(16);
        actions.add(new CoupleBillPricingAction());
        actions.add(new RedBillPricingAction());
        actions.add(new PriceRuleMatchAction());
        actions.add(new SettlePricingAction());
        actions.add(new ValueWriteBackAction());
        actions.add(new PathPricingAction());
        return actions;
    }

    public static List<AbstractSettleAction> getGenAndPriceActions() {
        ArrayList<AbstractSettleAction> actions = new ArrayList<AbstractSettleAction>(16);
        actions.addAll(SettleActionFactory.buildPreMatchActions());
        actions.add(new GenerateSettleBillAction());
        actions.add(new SettleParamValueSetAction());
        actions.addAll(SettleActionFactory.getPriceActions());
        return actions;
    }

    public static List<AbstractSettleAction> buildSettleActions() {
        ArrayList<AbstractSettleAction> actions = new ArrayList<AbstractSettleAction>(16);
        actions.addAll(SettleActionFactory.getGenAndPriceActions());
        actions.add(new GeneratedBillRecalAction());
        actions.add(new BillOperExecuteAction());
        actions.add(new BizFlowExecuteAction());
        return actions;
    }

    public static List<AbstractSettleAction> buildRedoActions() {
        ArrayList<AbstractSettleAction> actions = new ArrayList<AbstractSettleAction>(16);
        actions.add(new BillOperRedoAction());
        actions.add(new BizFlowExecuteAction());
        return actions;
    }

    public static List<AbstractSettleAction> buildCheckSettleActions() {
        ArrayList<AbstractSettleAction> actions = new ArrayList<AbstractSettleAction>(3);
        actions.add(new SettleJudgeCheckAction());
        actions.add(new RelationMatchAction());
        return actions;
    }

    public static List<AbstractSettleAction> buildValidateSettleActions() {
        ArrayList<AbstractSettleAction> actions = new ArrayList<AbstractSettleAction>(3);
        actions.add(new SettleJudgeAction());
        actions.add(new BuildSrcBillModelAction());
        actions.add(new ValidateSettleAction());
        return actions;
    }

    public static List<AbstractSettleAction> buildBillPricingActions() {
        ArrayList<AbstractSettleAction> actions = new ArrayList<AbstractSettleAction>(16);
        actions.add(new DynaObjJudgeMatchAction());
        actions.add(new BuildSelfCoupleBillAction());
        actions.addAll(SettleActionFactory.buildPricingActions());
        return actions;
    }

    public static List<AbstractSettleAction> buildPricingActions() {
        ArrayList<AbstractSettleAction> actions = new ArrayList<AbstractSettleAction>(16);
        actions.add(new PriceRuleMatchAction());
        actions.add(new SettlePricingAction());
        actions.add(new PricingValueWriteBackAction());
        actions.add(new GeneratedBillRecalAction());
        return actions;
    }
}

