/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.log.api.AppLogInfo;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.helper.AppLogInfoHelper;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.result.BatchBillOpResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.CommonLang;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.log.SettleLogBatchUpdater;

public abstract class AbstractUpdLogAction
extends AbstractSettleAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CommonUtils.mapIsEmpty(this.getReqContext().getAllLogs());
    }

    protected List<List<Long>> getBillGenSequence() {
        Collection<SettleLogHandler> allLogs = this.getReqContext().getAllLogs().values();
        ArrayList<List<Long>> genSequences = new ArrayList<List<Long>>(allLogs.size());
        for (SettleLogHandler logHandler : allLogs) {
            genSequences.add(logHandler.getSequence().getAllExecBillIds());
        }
        return genSequences;
    }

    protected void updateLogAndResult(BatchBillOpResult positiveExecute) {
        SettleLogBatchUpdater logsUpd = new SettleLogBatchUpdater();
        Collection<SettleLogHandler> logs = this.getReqContext().getAllLogs().values();
        for (SettleLogHandler log : logs) {
            if (!log.isSuccessGenerateAllBills()) continue;
            Long redoBillId = log.getDataLog().getLong("sourceid");
            for (DynamicObject logEntryInfo : log.getDataLogInfo()) {
                long stBillId = logEntryInfo.getLong("settlebillid");
                String billstatus = positiveExecute.getBillStatusInfo().get(stBillId);
                String failReason = positiveExecute.getFailReasonInfo().get(stBillId);
                if (failReason == null) {
                    failReason = "";
                }
                logsUpd.addSettleStatusInfo(redoBillId, stBillId, billstatus, failReason);
            }
            log.updateSettleBillStatus(positiveExecute);
            log.getDataLog().set("createstatus", (Object)logsUpd.getLogStatus(redoBillId));
            this.updateResultInfo(log);
        }
        logsUpd.updateLogInfo();
    }

    private void updateResultInfo(SettleLogHandler settleLogHandler) {
        DynamicObject log = settleLogHandler.getDataLog();
        Long billId = log.getLong("sourceid");
        String sourceBillNo = log.getString("sourcenum");
        String status = log.getString("createstatus");
        DynamicObjectCollection logDetail = log.getDynamicObjectCollection("entryentity");
        if (!"A".equals(status)) {
            StringBuilder failReason = new StringBuilder();
            for (DynamicObject logInfo : logDetail) {
                failReason.append(logInfo.getString("failcause"));
                failReason.append(" ");
            }
            this.getReqContext().getOperResult().addFailInfo(billId, ModelLang.billGenerateFail(sourceBillNo, failReason.toString()));
        } else if (CommonUtils.collectionIsEmpty(logDetail)) {
            this.getReqContext().getOperResult().addFailInfo(billId, ModelLang.noSettleBillGenerate());
        }
    }

    protected void doOperLogRecord(String opName) {
        String executeOp = CommonLang.executeOp(opName);
        ArrayList<AppLogInfo> appLogs = new ArrayList<AppLogInfo>(16);
        Map<String, Set<Long>> reqBillIds = this.getReqContext().getReqBillIds();
        Map<Long, String> failReasons = this.getReqContext().getOperResult().getFailReasons();
        for (Map.Entry<String, Set<Long>> reqBillIdsEntry : reqBillIds.entrySet()) {
            String billEntity = reqBillIdsEntry.getKey();
            Set<Long> billIds = reqBillIdsEntry.getValue();
            for (Long billId : billIds) {
                String billNo = this.getBillNo(billId);
                if (billNo == null) continue;
                String description = failReasons.get(billId);
                if (StringUtils.isEmpty((CharSequence)description)) {
                    description = executeOp;
                }
                appLogs.add(AppLogInfoHelper.buildAppLogInfo(opName, description, billNo, billId, billEntity));
            }
        }
        AppLogInfoHelper.batchOperLog(appLogs);
    }

    private String getBillNo(Long billId) {
        SettleLogHandler logHandler = this.getReqContext().getLog(billId);
        if (logHandler != null) {
            return logHandler.getDataLog().getString("sourcenum");
        }
        return null;
    }
}

