/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.helper.BizFlowServiceHelper;
import kd.scmc.ism.business.helper.InterOrgBizHelper;
import kd.scmc.ism.common.model.entity.BillExecSequence;
import kd.scmc.ism.common.model.entity.BillExecuteInfo;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.utils.CommonUtils;

public class BizFlowExecuteAction
extends AbstractSettleAction {
    public static final int MULTI_BOARDCAST_WAIT_TIMES = 4;

    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CommonUtils.mapIsEmpty(this.getReqContext().getAllLogs());
    }

    @Override
    protected void doAction() {
        Map<Long, SettleLogHandler> allLogs = this.getReqContext().getAllLogs();
        HashMap<Long, BillExecSequence> billExecSeqs = new HashMap<Long, BillExecSequence>(allLogs.size());
        for (Map.Entry<Long, SettleLogHandler> logInfo : allLogs.entrySet()) {
            BillExecSequence sequence = logInfo.getValue().getSequence();
            if (!sequence.isConfigBizFlowKey()) continue;
            billExecSeqs.put(logInfo.getKey(), logInfo.getValue().getSequence());
        }
        if (billExecSeqs.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> billObjs = InterOrgBizHelper.getBillInfosByBillExecSeq(billExecSeqs.values());
        String pref = String.valueOf(new Date().getTime());
        for (BillExecSequence sequence : billExecSeqs.values()) {
            if (!this.canDoBizFlow(billObjs, sequence)) continue;
            String bizTraceNo = sequence.getBizTraceNo();
            Map<String, List<BillExecuteInfo>> groupExecSequence = sequence.getGroupExecSequence();
            for (Map.Entry<String, List<BillExecuteInfo>> gpentrySet : groupExecSequence.entrySet()) {
                String groupKey = pref + "-" + gpentrySet.getKey();
                List<BillExecuteInfo> billExecInfos = gpentrySet.getValue();
                this.executeBizFlow(bizTraceNo, groupKey, billExecInfos);
            }
        }
    }

    private boolean canDoBizFlow(Map<Long, DynamicObject> billObjs, BillExecSequence sequence) {
        for (BillExecuteInfo bec : sequence.getAllExecSequence()) {
            DynamicObject billObj = billObjs.get(bec.getBillId());
            if (billObj == null) {
                return false;
            }
            if ("C".equals(billObj.getString("billstatus"))) continue;
            return false;
        }
        return true;
    }

    private void executeBizFlow(String bizTraceNo, String groupKey, List<BillExecuteInfo> billExecInfos) {
        boolean isFrist = true;
        int seq = 0;
        for (int i = 0; i < billExecInfos.size(); ++i) {
            BillExecuteInfo billExecInfo = billExecInfos.get(i);
            if (StringUtils.isEmpty((CharSequence)billExecInfo.getBizFlowKey())) continue;
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("biztraceno", bizTraceNo);
            if (isFrist) {
                param.put("isfristbill", "1");
            } else {
                param.put("isfristbill", "0");
            }
            String listenerSign = groupKey + "_" + seq;
            String boardcastSign = groupKey + "_" + (seq + 1);
            param.put("listenersign", listenerSign);
            param.put("broadcastsign", boardcastSign);
            for (int j = 0; j < 4; ++j) {
                param.put("listenersign" + j, listenerSign);
                param.put("broadcastsign" + j, boardcastSign);
            }
            BizFlowServiceHelper.triggerBizFlowAsync(billExecInfo, param);
            isFrist = false;
            ++seq;
        }
    }
}

