/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.helper.MatchArgsHelper;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.args.BillSettleGenResult;
import kd.scmc.ism.common.model.args.GenerateBillArgs;
import kd.scmc.ism.common.model.args.GenerateResult;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.PlainDynaObjBillModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.match.engine.impl.GeneratePlanEntryMatchEngine;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.unit.impl.GeneratePlanMatchUnit;
import kd.scmc.ism.model.relation.AbstractRelationModel;
import kd.scmc.ism.model.relation.RelationEntryModel;

public class GenerateSettleBillAction
extends AbstractSettleAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CommonUtils.mapIsEmpty(this.getReqContext().getRelations());
    }

    @Override
    protected void doAction() {
        ISMRequestContext reqContext = this.getReqContext();
        Map<Long, List<AbstractRelationModel>> billToRelations = reqContext.getRelations();
        for (Map.Entry<Long, List<AbstractRelationModel>> entrySets : billToRelations.entrySet()) {
            Long billId = entrySets.getKey();
            BillSettleGenResult allResult = new BillSettleGenResult();
            List<AbstractRelationModel> relations = entrySets.getValue();
            HashSet<String> relationNums = new HashSet<String>(16);
            for (AbstractRelationModel relModel : relations) {
                BillSettleGenResult result = this.doRelationBillGenerate(relModel);
                relationNums.add(relModel.getRelationObj().getString("name"));
                allResult.combine(result);
            }
            SettleLogHandler billSettleLog = this.getReqContext().getLog(entrySets.getKey());
            if (billSettleLog.getDataLogInfo().isEmpty()) {
                SettleLogHandler logHandler = this.getReqContext().getLog(billId);
                String failReson = ModelLang.noSettleBillGenerate(((Object)relationNums).toString());
                logHandler.setSettleReason(failReson);
                logHandler.logNoGenInfo(relations);
                continue;
            }
            if (!billSettleLog.isSuccessGenerateAllBills()) {
                String failReson = ModelLang.partBillGenerateFail();
                this.getReqContext().getLog(billId).setSettleReason(failReson);
                reqContext.getOperResult().addFailInfo(billId, failReson);
                continue;
            }
            for (CoupleSettleBillsModel cpModel : allResult.getCpModels()) {
                reqContext.addSupDemBillInfo(cpModel);
            }
            for (SettleBillModel toOutBill : allResult.getToOutBillModel()) {
                reqContext.addToOutBill(toOutBill);
            }
        }
    }

    private BillSettleGenResult doRelationBillGenerate(AbstractRelationModel relModel) {
        BillSettleGenResult bsResult = new BillSettleGenResult();
        boolean genOutFrist = relModel.isGenOutFrist();
        if (genOutFrist) {
            SettleBillModel toOutBill = this.doGenToOutBill(relModel);
            bsResult.addToOutModel(toOutBill);
        }
        List<RelationEntryModel> relationDetails = relModel.getRelationEntries();
        if (relModel.isDemFrist()) {
            for (int i = relationDetails.size(); i > 0; --i) {
                RelationEntryModel relationEntry = relationDetails.get(i - 1);
                SettleBillModel demandBill = this.doGenDemandBill(relModel, relationEntry);
                SettleBillModel supplierBill = this.doGenSupplierBill(relModel, relationEntry);
                CoupleSettleBillsModel cpModel = this.createCoupleBillModel(relModel, relationEntry, supplierBill, demandBill);
                bsResult.addCpModel(cpModel);
            }
        } else {
            for (RelationEntryModel relationEntry : relationDetails) {
                SettleBillModel supplierBill = this.doGenSupplierBill(relModel, relationEntry);
                SettleBillModel demandBill = this.doGenDemandBill(relModel, relationEntry);
                CoupleSettleBillsModel cpModel = this.createCoupleBillModel(relModel, relationEntry, supplierBill, demandBill);
                bsResult.addCpModel(cpModel);
            }
        }
        if (!genOutFrist) {
            SettleBillModel toOutBill = this.doGenToOutBill(relModel);
            bsResult.addToOutModel(toOutBill);
        }
        relModel.setResult(bsResult);
        return bsResult;
    }

    private CoupleSettleBillsModel createCoupleBillModel(AbstractRelationModel relModel, RelationEntryModel relationEntry, SettleBillModel supplierBill, SettleBillModel demandBill) {
        if (supplierBill != null || demandBill != null) {
            CoupleSettleBillsModel cpModel = CoupleSettleBillsModel.build(supplierBill, demandBill);
            cpModel.setSrcBillModel(relModel.getBillModel());
            cpModel.setEntryModel(relationEntry);
            return cpModel;
        }
        return null;
    }

    private SettleBillModel doGenSupplierBill(AbstractRelationModel relModel, RelationEntryModel entrySettleRelation) {
        DynamicObject supplierPlan = entrySettleRelation.getObj().getDynamicObject("suppliergenerateplan");
        if (supplierPlan == null) {
            return null;
        }
        GenerateBillArgs generateBillArgs = GenerateBillArgs.createSupArgs(relModel, entrySettleRelation);
        return this.doBillGenerateAndLog(supplierPlan, relModel, generateBillArgs);
    }

    private SettleBillModel doGenDemandBill(AbstractRelationModel relModel, RelationEntryModel entrySettleRelation) {
        DynamicObject demandPlan = entrySettleRelation.getObj().getDynamicObject("demandgenerateplan");
        if (demandPlan == null) {
            return null;
        }
        GenerateBillArgs generateBillArgs = GenerateBillArgs.createDemArgs(relModel, entrySettleRelation);
        return this.doBillGenerateAndLog(demandPlan, relModel, generateBillArgs);
    }

    private SettleBillModel doGenToOutBill(AbstractRelationModel relModel) {
        DynamicObject toOutGenPlan = relModel.getToOutGenPlan();
        if (toOutGenPlan == null) {
            return null;
        }
        GenerateBillArgs generateBillArgs = GenerateBillArgs.createToOutArgs(relModel);
        return this.doBillGenerateAndLog(toOutGenPlan, relModel, generateBillArgs);
    }

    private SettleBillModel doBillGenerateAndLog(DynamicObject genPlan, AbstractRelationModel relModel, GenerateBillArgs genArgs) {
        MatchResult<GeneratePlanMatchUnit> matchResult;
        GeneratePlanEntryMatchEngine matchEngine = this.getServiceContext().getService(GeneratePlanEntryMatchEngine.class);
        PlainDynaObjBillModel billModel = new PlainDynaObjBillModel(relModel.getBillModel().getObj());
        MatchArgs matchArgs = MatchArgsHelper.buildEntryIdMatchArgs(billModel, DynamicObjectUtil.getPkValue(genPlan));
        RelationEntryModel entryModel = genArgs.getEntryModel();
        if (entryModel != null) {
            matchArgs.putAddtionInfo("supplier", entryModel.getSupplierId());
            matchArgs.putAddtionInfo("demand", entryModel.getDemandId());
        }
        if (!(matchResult = matchEngine.doMatch(matchArgs)).isMatch()) {
            return null;
        }
        GenerateResult result = matchResult.getMatchedUnit().doGenerate(genArgs, this.getServiceContext());
        if (result == null) {
            return null;
        }
        SettleLogHandler log = this.getReqContext().getLog(relModel.getBillModel().getId());
        log.logInfo(relModel, genArgs, result);
        return result.getBill();
    }
}

