/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.match;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.common.model.assist.MainBillAssistant;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.SelfCoupleSettleBilModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.unit.impl.SettleJudgeMatchUnit;

public class BuildSelfCoupleBillAction
extends AbstractSettleAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CommonUtils.mapIsEmpty(this.getReqContext().getMatchUnits(SettleJudgeMatchUnit.class));
    }

    @Override
    protected void doAction() {
        HashMap billModels = new HashMap(16);
        Map<Long, MatchResult<?>> judgeUnits = this.getReqContext().getMatchUnits(SettleJudgeMatchUnit.class);
        MainBillAssistant billAssistant = this.getServiceContext().getBillAssistant();
        for (Map.Entry<Long, MatchResult<?>> entry : judgeUnits.entrySet()) {
            Long billId = entry.getKey();
            MatchResult<?> matchResult = entry.getValue();
            SettleJudgeMatchUnit settleJudgeUnit = (SettleJudgeMatchUnit)matchResult.getMatchedUnit();
            SettleBillModel billModel = this.getReqContext().getSrcBillModel(billId);
            DynamicObject billObj = billModel.getObj();
            List<SettleBillEntryModel> entries = billModel.getEntries();
            for (SettleBillEntryModel entryModel : entries) {
                DynamicObject demand;
                DynamicObject entryObj = entryModel.getObj();
                if (!settleJudgeUnit.isConfigSupAndDem()) continue;
                DynamicObject supplier = DynamicObjectUtil.getObject(billObj, entryObj, settleJudgeUnit.getSettleOrgKey());
                if (DynamicObjectUtil.checkIsNotOrg(supplier, demand = DynamicObjectUtil.getObject(billObj, entryObj, settleJudgeUnit.getOwnerOrgKey()))) continue;
                Long supplierId = DynamicObjectUtil.getPkValue(supplier);
                Long demandId = DynamicObjectUtil.getPkValue(demand);
                if (!CommonUtils.idIsNotNull(supplierId) || !CommonUtils.idIsNotNull(demandId) || supplierId.equals(demandId)) continue;
                String buildKey = this.buildKey(billId, supplierId, demandId);
                CommonUtils.mapGetListValue(billModels, buildKey).add(entryModel);
                String srcBillEntity = (String)billModel.getValue("srcbillentity");
                Long srcBillId = (Long)billModel.getValue("srcbillid");
                billAssistant.preLoadData(srcBillEntity, srcBillId);
            }
        }
        for (Map.Entry<Long, MatchResult<Object>> entry : billModels.entrySet()) {
            SettleBillModel billModel;
            SettleBillModel headModel = null;
            Long tempId = null;
            ArrayList<Long> entryIds = new ArrayList<Long>(16);
            List entris = (List)((Object)entry.getValue());
            for (SettleBillEntryModel entryModel : entris) {
                if (headModel == null) {
                    headModel = entryModel.getBillModel();
                    tempId = entryModel.getId();
                }
                entryIds.add(entryModel.getId());
            }
            String key = (String)((Object)entry.getKey());
            Long supId = this.getSupIdFromKey(key);
            Long demId = this.getDemIdFromKey(key);
            SelfCoupleSettleBilModel cpModel = SelfCoupleSettleBilModel.buildSingle(headModel, entryIds);
            cpModel.setId(tempId);
            cpModel.setSupplierId(supId);
            cpModel.setDemandId(demId);
            String srcBillEntity = (String)cpModel.getValue("srcbillentity");
            Long srcBillId = (Long)cpModel.getValue("srcbillid");
            if (StringUtils.isNotEmpty((CharSequence)srcBillEntity) && CommonUtils.idIsNotNull(srcBillId) && (billModel = billAssistant.getMainBillObj(srcBillEntity, srcBillId)) != null) {
                cpModel.setSrcBillModel(billModel);
            }
            this.getReqContext().addSupDemBillInfo(cpModel);
        }
    }

    private String buildKey(Long billId, Long supId, Long demId) {
        StringBuilder strs = new StringBuilder();
        strs.append(billId);
        strs.append("-");
        strs.append(supId);
        strs.append("-");
        strs.append(demId);
        return strs.toString();
    }

    public Long getSupIdFromKey(String key) {
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            return Long.valueOf(key.split("-")[1]);
        }
        return 0L;
    }

    public Long getDemIdFromKey(String key) {
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            return Long.valueOf(key.split("-")[2]);
        }
        return 0L;
    }
}

