/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.match;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.MServiceLang;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;
import kd.scmc.ism.model.mapcfg.fieldinfo.BillFieldInfo;
import kd.scmc.ism.model.match.engine.impl.GeneratePlanEntryMatchEngine;
import kd.scmc.ism.model.match.engine.impl.SettleJudgeMatchEngine;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.unit.impl.SettleJudgeMatchUnit;

public class BuildSrcBillModelAction
extends AbstractSettleAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CommonUtils.mapIsEmpty(this.getReqContext().getMatchUnits(SettleJudgeMatchUnit.class));
    }

    @Override
    protected void doAction() {
        Map<Long, MatchResult<?>> judgeUnits = this.getReqContext().getMatchUnits(SettleJudgeMatchUnit.class);
        Map<String, Set<Long>> transToBillMapIds = this.transToBillMapIds(judgeUnits);
        for (Map.Entry<String, Set<Long>> entry : transToBillMapIds.entrySet()) {
            String billEntityType = entry.getKey();
            Set<Long> billIds = entry.getValue();
            boolean contain = this.getServiceContext().getMapCfg().isContain(billEntityType);
            if (contain) {
                Set<String> allSrcField = this.buildSourceQueryFields(billEntityType);
                this.buildModel(billEntityType, billIds, allSrcField);
                continue;
            }
            for (Long billId : billIds) {
                this.getReqContext().getOperResult().addFailInfo(billId, MServiceLang.billNotConfigMapping(billEntityType));
            }
        }
    }

    private Map<String, Set<Long>> transToBillMapIds(Map<Long, MatchResult<?>> judgeUnits) {
        HashMap<String, Set<Long>> billMapIds = new HashMap<String, Set<Long>>(16);
        for (Map.Entry<Long, MatchResult<?>> judgeEntry : judgeUnits.entrySet()) {
            Long billId = judgeEntry.getKey();
            SettleJudgeMatchUnit value = (SettleJudgeMatchUnit)judgeEntry.getValue().getMatchedUnit();
            CommonUtils.mapGetSetValue(billMapIds, value.getBillEntityType()).add(billId);
        }
        return billMapIds;
    }

    private void buildModel(String billEntityType, Set<Long> billIds, Set<String> allSrcField) {
        DynamicObject[] matchBills;
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        for (DynamicObject bill : matchBills = BusinessDataServiceHelper.load((String)billEntityType, (String)CommonUtils.transToStr(allSrcField), (QFilter[])new QFilter("id", "in", billIds).toArray())) {
            SettleBillModel billModel = SettleBillModel.build(bill, mapCfg);
            this.getReqContext().addSrcBillModel(billModel);
        }
    }

    private Set<String> buildSourceQueryFields(String billEntityType) {
        SettleJudgeMatchEngine judgeMatchEngine;
        Set<String> judgeFields;
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("id");
        Map<String, BillFieldInfo> map = mapCfg.getBillFieldInfoMap(billEntityType);
        if (CommonUtils.mapIsNotEmpty(map)) {
            for (BillFieldInfo fieldInfo : map.values()) {
                String selectField = fieldInfo.getSrcBillFieldKey();
                fields.add(selectField);
            }
        }
        if (CommonUtils.collectionIsNotEmpty(judgeFields = (judgeMatchEngine = this.getServiceContext().getService(SettleJudgeMatchEngine.class)).getJudgeFields(billEntityType))) {
            fields.addAll(judgeFields);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntityType);
        String mainOrg = dataEntityType.getMainOrg();
        fields.add(mainOrg);
        GeneratePlanEntryMatchEngine gpeMatchEngine = this.getServiceContext().getService(GeneratePlanEntryMatchEngine.class);
        Set<String> conditionFields = gpeMatchEngine.getConditionFields(billEntityType);
        if (CommonUtils.collectionIsNotEmpty(conditionFields)) {
            fields.addAll(conditionFields);
        }
        if ("im_purinbill".equals(billEntityType) || "im_ospurinbill".equals(billEntityType)) {
            fields.add("billentry.baseqty");
            fields.add("billentry.baseunit");
        }
        return fields;
    }
}

