/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.match;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.common.errocode.ISMErrorCode;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.PlainObjBillModel;
import kd.scmc.ism.model.match.engine.impl.BizDirectMatchEngine;
import kd.scmc.ism.model.match.engine.impl.SettleJudgeMatchEngine;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.entity.MatchResult;

public class JudgeAndBizDirectAction
extends AbstractSettleAction {
    @Override
    protected void doAction() {
        ISMRequestContext reqContext = this.getReqContext();
        Map<String, Set<Long>> reqBillIds = reqContext.getReqBillIds();
        for (Map.Entry<String, Set<Long>> entry : reqBillIds.entrySet()) {
            String billEntityType = entry.getKey();
            Set<Long> billIds = entry.getValue();
            DynamicObjectCollection billInfoObjs = this.queryBillInfos(billEntityType, billIds);
            for (DynamicObject billInfoObj : billInfoObjs) {
                PlainObjBillModel billModel = new PlainObjBillModel(billInfoObj, billEntityType);
                reqContext.addSrcPlainObj(billModel);
                MatchArgs matchArgs = MatchArgs.buildMatch(billModel);
                MatchResult doSJMatch = this.getSettleJudgeEngine().doMatch(matchArgs);
                if (!doSJMatch.isMatch()) {
                    reqContext.getOperResult().addFailInfo((Long)billModel.getId(), ISMErrorCode.notMatchJudge());
                    continue;
                }
                reqContext.putMatchResult(billModel.getId(), doSJMatch);
                MatchResult doDBMatch = this.getBizDirectEngine().doMatch(matchArgs);
                if (!doDBMatch.isMatch()) continue;
                reqContext.putMatchResult(billModel.getId(), doDBMatch);
            }
        }
    }

    private DynamicObjectCollection queryBillInfos(String billEntityType, Set<Long> billIds) {
        Set<String> allDimField = this.getAllQueryFields(billEntityType);
        allDimField.add("id");
        String selectFields = CommonUtils.transToStr(allDimField);
        DynamicObjectCollection billInfoObjs = QueryServiceHelper.query((String)billEntityType, (String)selectFields, (QFilter[])new QFilter("id", "in", billIds).toArray());
        return billInfoObjs;
    }

    protected SettleJudgeMatchEngine getSettleJudgeEngine() {
        SettleJudgeMatchEngine judgeMatchEngine = this.getServiceContext().getService(SettleJudgeMatchEngine.class);
        return judgeMatchEngine;
    }

    protected BizDirectMatchEngine getBizDirectEngine() {
        BizDirectMatchEngine bizDirectEngine = this.getServiceContext().getService(BizDirectMatchEngine.class);
        return bizDirectEngine;
    }

    protected Set<String> getAllQueryFields(String billEntityType) {
        BizDirectMatchEngine bizDirectEngine;
        Set<String> bdfields;
        HashSet<String> srcBillQueryField = new HashSet<String>(16);
        SettleJudgeMatchEngine settleJudgeEngine = this.getSettleJudgeEngine();
        Set<String> sjfields = settleJudgeEngine.getAllFilterField().get(billEntityType);
        if (CommonUtils.collectionIsNotEmpty(sjfields)) {
            srcBillQueryField.addAll(sjfields);
        }
        if (CommonUtils.collectionIsNotEmpty(bdfields = (bizDirectEngine = this.getBizDirectEngine()).getAllFilterField().get(billEntityType))) {
            srcBillQueryField.addAll(bdfields);
        }
        return srcBillQueryField;
    }
}

