/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.match;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.business.helper.ISMReqContextHelper;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.group.rel.collect.GroupConditionCollector;
import kd.scmc.ism.model.match.engine.impl.SettleRelationMatchEngine;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.entity.impl.RelationMatchArgs;
import kd.scmc.ism.model.match.loader.impl.SettleRelationLoader;
import kd.scmc.ism.model.match.unit.impl.SettleJudgeMatchUnit;
import kd.scmc.ism.model.match.unit.impl.SettleRelationMatchUnit;
import kd.scmc.ism.model.relation.AbstractRelationModel;
import kd.scmc.ism.model.relation.RelationModelFactory;

public class RelationMatchAction
extends AbstractSettleAction {
    private SettleRelationMatchEngine engine;

    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CommonUtils.collectionIsEmpty(this.getReqContext().getSrcBillModels()) || CommonUtils.mapIsEmpty(this.getReqContext().getMatchUnits(SettleJudgeMatchUnit.class));
    }

    @Override
    protected void doAction() {
        Map<Long, RelationMatchArgs> matchArgs = this.buildMatchArgs();
        if (!matchArgs.isEmpty()) {
            this.initGroup(matchArgs);
            this.executeMatch(matchArgs);
        }
    }

    private Map<Long, RelationMatchArgs> buildMatchArgs() {
        ISMRequestContext reqContext = this.getReqContext();
        Collection<SettleBillModel> srcBillModels = reqContext.getSrcBillModels();
        HashMap<Long, RelationMatchArgs> matchArgs = new HashMap<Long, RelationMatchArgs>(srcBillModels.size());
        HashSet<Object> relationIds = new HashSet<Object>(16);
        HashSet<Object> supplierIds = new HashSet<Object>(16);
        HashSet<Object> demandIds = new HashSet<Object>(16);
        Map<Long, MatchResult<?>> judgeUnits = reqContext.getMatchUnits(SettleJudgeMatchUnit.class);
        for (SettleBillModel billModel : srcBillModels) {
            Long billId = billModel.getId();
            DynamicObject billObj = billModel.getObj();
            MatchResult<?> matchResult = judgeUnits.get(billId);
            if (matchResult == null) continue;
            SettleJudgeMatchUnit settleJudgeUnit = (SettleJudgeMatchUnit)judgeUnits.get(billId).getMatchedUnit();
            String direct = ISMReqContextHelper.getBizDirect(this.getReqContext(), billId);
            List<SettleBillEntryModel> entries = billModel.getEntries();
            for (SettleBillEntryModel entryModel : entries) {
                DynamicObject relationObj;
                DynamicObject entryObj = entryModel.getObj();
                RelationMatchArgs args = new RelationMatchArgs(entryModel);
                if (settleJudgeUnit.isConfigSettleRelation() && (relationObj = DynamicObjectUtil.getObject(billObj, entryObj, settleJudgeUnit.getSettleRelationKey())) != null) {
                    relationIds.add(DynamicObjectUtil.getPkValue(relationObj));
                    args.setSettleRelation(relationObj);
                }
                if (settleJudgeUnit.isConfigSupAndDem()) {
                    DynamicObject demand;
                    DynamicObject supplier = DynamicObjectUtil.getObject(billObj, entryObj, settleJudgeUnit.getSettleOrgKey());
                    if (DynamicObjectUtil.checkIsNotOrg(supplier, demand = DynamicObjectUtil.getObject(billObj, entryObj, settleJudgeUnit.getOwnerOrgKey()))) continue;
                    Long supplierId = DynamicObjectUtil.getPkValue(supplier);
                    Long demandId = DynamicObjectUtil.getPkValue(demand);
                    if (CommonUtils.idIsNotNull(supplierId) && CommonUtils.idIsNotNull(demandId) && !supplierId.equals(demandId)) {
                        supplierIds.add(supplierId);
                        demandIds.add(demandId);
                        args.setSupAndDem(supplier, demand, direct);
                    }
                }
                if (!args.canDoMatch()) continue;
                matchArgs.put(args.getMatchId(), args);
            }
        }
        if (!matchArgs.isEmpty()) {
            Collection<DynamicObject> relations = SettleRelationLoader.build(supplierIds, demandIds, relationIds).getObjects();
            this.getSettleRelationEngine().loadObjs(relations);
        }
        return matchArgs;
    }

    private void initGroup(Map<Long, RelationMatchArgs> matchArgs) {
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(16);
        relations.addAll(this.getSettleRelationEngine().getAllObjs());
        relations.addAll(this.getServiceContext().getDynaRelationEngine().getAllObjs());
        GroupConditionCollector collector = GroupConditionCollector.create(this.getServiceContext().getCtrlInfos());
        collector.collect(this.getReqContext().getSrcBillModels(), relations);
        this.getServiceContext().getClassfier().loadCollectData(collector);
    }

    private void executeMatch(Map<Long, RelationMatchArgs> matchArgs) {
        ISMRequestContext reqContext = this.getReqContext();
        for (SettleBillModel billModel : reqContext.getSrcBillModels()) {
            long billId = billModel.getId();
            HashMap<String, AbstractRelationModel> relIdMap = new HashMap<String, AbstractRelationModel>(16);
            ArrayList<SettleBillEntryModel> failedMatchEntries = new ArrayList<SettleBillEntryModel>(16);
            for (SettleBillEntryModel entryModel : billModel.getEntries()) {
                long entryId = entryModel.getId();
                MatchArgs relationMatchArgs = matchArgs.get(entryId);
                if (relationMatchArgs == null) continue;
                MatchResult<SettleRelationMatchUnit> matchResult = this.doRelationMatch(relationMatchArgs);
                if (!matchResult.isMatch()) {
                    failedMatchEntries.add(entryModel);
                    continue;
                }
                if (!failedMatchEntries.isEmpty()) continue;
                String key = RelationModelFactory.buildKey(matchResult);
                reqContext.putMatchResult(entryId, matchResult);
                AbstractRelationModel relationModel = (AbstractRelationModel)relIdMap.get(key);
                if (relationModel == null) {
                    relationModel = RelationModelFactory.create(matchResult, billModel);
                    relationModel.setKey(key);
                    relIdMap.put(key, relationModel);
                }
                relationModel.addRow(entryId);
            }
            if (!failedMatchEntries.isEmpty()) {
                String failReason = this.parseFailInfos(billId, failedMatchEntries, matchArgs);
                reqContext.getLog(billId).setMatchFail(failReason);
                reqContext.getOperResult().addFailInfo((Long)billId, failReason);
                continue;
            }
            if (!relIdMap.isEmpty()) {
                for (AbstractRelationModel relationModel : relIdMap.values()) {
                    reqContext.addRelationModel(relationModel);
                }
                continue;
            }
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\uff1a\u5355\u636e\u4e0d\u9700\u8981\u8fdb\u884c\u7ed3\u7b97\u3010" + billId + "\u3011");
            reqContext.getOperResult().addFailInfo((Long)billId, ModelLang.notNeedSettle());
        }
    }

    private MatchResult<SettleRelationMatchUnit> doRelationMatch(MatchArgs relationMatchArgs) {
        MatchResult<SettleRelationMatchUnit> staticResult = this.getSettleRelationEngine().doMatch(relationMatchArgs);
        if (!staticResult.isMatch()) {
            MatchResult<SettleRelationMatchUnit> dynaResult = this.getServiceContext().getDynaRelationEngine().doMatch(relationMatchArgs);
            return dynaResult;
        }
        return staticResult;
    }

    private String parseFailInfos(long billId, List<SettleBillEntryModel> failedMatchEntries, Map<Long, RelationMatchArgs> matchArgs) {
        HashSet<String> relationNumbs = new HashSet<String>(16);
        HashSet<String> supAndDems = new HashSet<String>(16);
        for (SettleBillEntryModel entryModel : failedMatchEntries) {
            RelationMatchArgs args = matchArgs.get(entryModel.getId());
            if (args.getSettleRelation() != null) {
                relationNumbs.add(args.getSettleRelation().getString("name"));
                continue;
            }
            DynamicObject supplierOrg = args.getSupplierOrg();
            DynamicObject demandOrg = args.getDemandOrg();
            if (supplierOrg == null || demandOrg == null) continue;
            String supplierNum = supplierOrg.getString("name");
            String demandNum = demandOrg.getString("name");
            supAndDems.add(ModelLang.supAndDem(supplierNum, demandNum));
        }
        StringBuilder failResons = new StringBuilder();
        if (!relationNumbs.isEmpty()) {
            failResons.append(ModelLang.relationIsUnenable());
            failResons.append(relationNumbs);
            failResons.append('\n');
        }
        if (!supAndDems.isEmpty()) {
            if (StringUtils.isEmpty((CharSequence)ISMReqContextHelper.getBizDirect(this.getReqContext(), billId))) {
                failResons.append(ModelLang.noMatcedDirect());
            } else {
                failResons.append(ModelLang.matchRelationFail());
                failResons.append(supAndDems);
            }
        }
        return failResons.toString();
    }

    public SettleRelationMatchEngine getSettleRelationEngine() {
        if (this.engine == null) {
            this.engine = SettleRelationMatchEngine.build(this.getServiceContext().getClassfier());
            this.engine.setCtrlChecker(this.getServiceContext().getCtrlInfos());
        }
        return this.engine;
    }
}

