/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.param;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.match.engine.impl.SettleParamMatchEngine;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.unit.impl.SettleParamMatchUnit;
import kd.scmc.ism.model.relation.AbstractRelationModel;
import kd.scmc.ism.model.relation.RelationEntryModel;

public class SettleParamMatchAction
extends AbstractSettleAction {
    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || CommonUtils.mapIsEmpty(this.getReqContext().getRelations());
    }

    @Override
    protected void doAction() {
        SettleParamMatchEngine settleParamMatchEngine = this.initMatchEngine();
        Map<Long, List<AbstractRelationModel>> relationModels = this.getReqContext().getRelations();
        for (Map.Entry<Long, List<AbstractRelationModel>> relationsEntry : relationModels.entrySet()) {
            Long billId = relationsEntry.getKey();
            SettleBillModel srcBillModel = this.getReqContext().getSrcBillModel(billId);
            List<AbstractRelationModel> relations = relationsEntry.getValue();
            for (AbstractRelationModel relaiton : relations) {
                for (RelationEntryModel entryModel : relaiton.getRelationEntries()) {
                    HashMap<String, Object> groupInf = new HashMap<String, Object>(16);
                    groupInf.put("supplier", entryModel.getSupplierId());
                    groupInf.put("demand", entryModel.getDemandId());
                    MatchArgs matchArgs = MatchArgs.buildMatch(srcBillModel, groupInf);
                    MatchResult<SettleParamMatchUnit> doMatch = settleParamMatchEngine.doMatch(matchArgs);
                    entryModel.setSettleParamMU(doMatch);
                }
            }
        }
    }

    private SettleParamMatchEngine initMatchEngine() {
        HashSet<Long> supIds = new HashSet<Long>(16);
        HashSet<Long> demIds = new HashSet<Long>(16);
        Map<Long, List<AbstractRelationModel>> relationModels = this.getReqContext().getRelations();
        for (Map.Entry<Long, List<AbstractRelationModel>> relationsEntry : relationModels.entrySet()) {
            List<AbstractRelationModel> relations = relationsEntry.getValue();
            for (AbstractRelationModel relaiton : relations) {
                for (RelationEntryModel entryModel : relaiton.getRelationEntries()) {
                    supIds.add(entryModel.getSupplierId());
                    demIds.add(entryModel.getDemandId());
                }
            }
        }
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"ism_settleparam", (QFilter[])new QFilter("demand", "in", demIds).and("supplier", "in", supIds).and("enable", "=", (Object)Boolean.TRUE).toArray());
        SettleParamMatchEngine engine = SettleParamMatchEngine.build(this.getServiceContext().getMapCfg());
        engine.setCtrlChecker(this.getServiceContext().getCtrlInfos());
        engine.loadObjs(objs.values());
        return engine;
    }
}

