/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.pricing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.action.impl.pricing.AbstractPricingAction;
import kd.scmc.ism.common.consts.config.SettleLogConsts;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;

public class CoupleBillPricingAction
extends AbstractPricingAction {
    private Set<String> groupNumbers = new HashSet<String>();
    private Map<Long, Set<String>> cpIdToKey = new HashMap<Long, Set<String>>(16);
    private List<CoupleSettleBillsModel> onlySupModels = new ArrayList<CoupleSettleBillsModel>(16);
    private List<CoupleSettleBillsModel> onlyDemModels = new ArrayList<CoupleSettleBillsModel>(16);
    private static final String[] QUERY_FIELD = new String[]{"settlecy", "exratedate", "price", "priceandtax", "taxrateid", "groupnumber", "groupseq", "mainbizorg"};

    @Override
    protected boolean isSkipAction() {
        this.initNeedCoupleBillPricing();
        return super.isSkipAction() || this.groupNumbers.isEmpty();
    }

    private void initNeedCoupleBillPricing() {
        ISMRequestContext reqContext = this.getReqContext();
        if (reqContext == null) {
            return;
        }
        List<CoupleSettleBillsModel> supDemBillInfos = reqContext.getSupDemBillInfos();
        for (CoupleSettleBillsModel cpModel : supDemBillInfos) {
            Set groupNumbs;
            SettleBillModel supBillModel = (SettleBillModel)cpModel.getSupBillModel();
            SettleBillModel demBillModel = (SettleBillModel)cpModel.getDemBillModel();
            if (supBillModel != null && demBillModel == null) {
                groupNumbs = supBillModel.getValues("groupnumber").stream().filter(obj -> StringUtils.isNotBlank((Object)obj)).collect(Collectors.toSet());
                if (!CommonUtils.collectionIsNotEmpty(groupNumbs)) continue;
                this.onlySupModels.add(cpModel);
                for (Object groupNumb : groupNumbs) {
                    CommonUtils.mapGetSetValue(this.cpIdToKey, cpModel.getId()).add(this.buildKey(cpModel, (String)groupNumb));
                    this.groupNumbers.add((String)groupNumb);
                }
                continue;
            }
            if (supBillModel != null || demBillModel == null || !CommonUtils.collectionIsNotEmpty(groupNumbs = demBillModel.getValues("groupnumber").stream().filter(obj -> StringUtils.isNotBlank((Object)obj)).collect(Collectors.toSet()))) continue;
            this.onlyDemModels.add(cpModel);
            for (Object groupNumb : groupNumbs) {
                CommonUtils.mapGetSetValue(this.cpIdToKey, cpModel.getId()).add(this.buildKey(cpModel, (String)groupNumb));
                this.groupNumbers.add((String)groupNumb);
            }
        }
    }

    @Override
    protected void doAction() {
        DynamicObjectCollection logBillInfos = this.getGroupLogInfo();
        if (logBillInfos.isEmpty()) {
            return;
        }
        HashMap<String, Set<Long>> supBillIds = new HashMap<String, Set<Long>>(logBillInfos.size());
        HashMap<String, Set<Long>> demBillIds = new HashMap<String, Set<Long>>(logBillInfos.size());
        HashMap<String, Set<Long>> billIds = new HashMap<String, Set<Long>>(logBillInfos.size());
        for (DynamicObject logInfo : logBillInfos) {
            Long settleBillId = logInfo.getLong("settlebillid");
            String settleBillType = logInfo.getString("settlebilltype");
            String relationType = logInfo.getString("relationtype");
            Long supplierId = logInfo.getLong("esupsettleorg");
            Long demandId = logInfo.getLong("edemandorg");
            String groupNum = logInfo.getString("groupnumber");
            String buildKey = this.buildKey(supplierId, demandId, groupNum);
            if ("supplier".equals(relationType)) {
                CommonUtils.mapGetSetValue(supBillIds, buildKey).add(settleBillId);
                CommonUtils.mapGetSetValue(billIds, settleBillType).add(settleBillId);
                continue;
            }
            if (!"demand".equals(relationType)) continue;
            CommonUtils.mapGetSetValue(demBillIds, buildKey).add(settleBillId);
            CommonUtils.mapGetSetValue(billIds, settleBillType).add(settleBillId);
        }
        Map<Long, SettleBillModel> groupModels = this.queryGroupBillModel(billIds);
        if (groupModels.isEmpty()) {
            return;
        }
        this.coupleBillPriceSync(this.onlySupModels, demBillIds, groupModels);
        this.coupleBillPriceSync(this.onlyDemModels, supBillIds, groupModels);
    }

    private DynamicObjectCollection getGroupLogInfo() {
        String queryFields = SettleLogConsts.buildEntryFields("settlerelation", "settlepath", "groupnumber", "supsettleorg", "oppositeorg", "esupsettleorg", "edemandorg", "settlebilltype", "settlebillid", "relationtype");
        DynamicObjectCollection logBillInfos = QueryServiceHelper.query((String)"ism_settlelog", (String)queryFields, (QFilter[])new QFilter(SettleLogConsts.getSettleLogInfo("groupnumber"), "in", this.groupNumbers).and(SettleLogConsts.getSettleLogInfo("relationtype"), "in", (Object)new String[]{"supplier", "demand"}).and("createstatus", "in", (Object)new String[]{"E", "A"}).toArray());
        return logBillInfos;
    }

    private Map<Long, SettleBillModel> queryGroupBillModel(Map<String, Set<Long>> billIds) {
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        HashMap<Long, SettleBillModel> groupBillInfos = new HashMap<Long, SettleBillModel>(16);
        for (Map.Entry<String, Set<Long>> billIdInfo : billIds.entrySet()) {
            DynamicObject[] billInfos;
            for (DynamicObject billObj : billInfos = this.queyBillObj(billIdInfo.getKey(), billIdInfo.getValue())) {
                groupBillInfos.put(DynamicObjectUtil.getPkValue(billObj), SettleBillModel.build(billObj, mapCfg));
            }
        }
        return groupBillInfos;
    }

    private DynamicObject[] queyBillObj(String entity, Set<Long> billIds) {
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        ArrayList<String> fields = new ArrayList<String>(16);
        fields.add("id");
        fields.add(mapCfg.getFieldKey(entity, "billentry").concat(".").concat("id"));
        for (String queryField : QUERY_FIELD) {
            String fieldInfo = mapCfg.getFieldSrcKey(entity, queryField);
            if (!StringUtils.isNotEmpty((CharSequence)fieldInfo)) continue;
            fields.add(fieldInfo);
        }
        DynamicObject[] billInfos = BusinessDataServiceHelper.load((String)entity, (String)CommonUtils.transToStr(fields), (QFilter[])new QFilter("id", "in", billIds).toArray());
        return billInfos;
    }

    private void coupleBillPriceSync(List<CoupleSettleBillsModel> singleCPModels, Map<String, Set<Long>> opBillIds, Map<Long, SettleBillModel> groupModels) {
        for (CoupleSettleBillsModel cpModelEntry : singleCPModels) {
            ArrayList<SettleBillModel> billModels = new ArrayList<SettleBillModel>(16);
            Set<String> keys = this.cpIdToKey.get(cpModelEntry.getId());
            if (keys == null || keys.isEmpty()) continue;
            for (String key : keys) {
                Set<Long> cpbillIds = opBillIds.get(key);
                if (cpbillIds == null || cpbillIds.isEmpty()) continue;
                for (Long cpBillId : cpbillIds) {
                    SettleBillModel billModel = groupModels.get(cpBillId);
                    if (billModel == null) continue;
                    billModels.add(billModel);
                }
            }
            if (billModels.isEmpty()) continue;
            SettleBillModel billModel = (SettleBillModel)billModels.get(0);
            CoupleSettleBillsModel cpBillModel = cpModelEntry;
            DynamicObject settleCurrency = (DynamicObject)billModel.getValueFromSrcObj("settlecy");
            cpBillModel.setSettleCurrencyId(DynamicObjectUtil.getPkValue(settleCurrency));
            Date date = (Date)billModel.getValueFromSrcObj("exratedate");
            cpBillModel.setExRateDate(date);
            cpBillModel.markPriced(PricingLang.coupleBillPricing());
            Map<String, SettleBillEntryModel> groupSeqToModel = this.parseGroupSeq(billModels);
            for (CoupleSettleBillEntriesModel cpEntryModel : cpBillModel.getEntries()) {
                String groupSeq = (String)cpEntryModel.getValue("groupseq");
                SettleBillEntryModel entryModel = groupSeqToModel.get(groupSeq);
                if (entryModel == null) continue;
                BigDecimal priceTax = (BigDecimal)entryModel.getValueFromSrcObj("priceandtax");
                BigDecimal price = (BigDecimal)entryModel.getValueFromSrcObj("price");
                if (priceTax == null) {
                    priceTax = price;
                }
                if (price == null) {
                    price = priceTax;
                }
                cpEntryModel.setPriceCurrencyId(DynamicObjectUtil.getPkValue(settleCurrency));
                cpEntryModel.setRePriceWithTax(priceTax);
                cpEntryModel.setRePrice(price);
                DynamicObject taxRateObj = (DynamicObject)entryModel.getValueFromSrcObj("taxrateid");
                cpEntryModel.setTaxRateId(DynamicObjectUtil.getPkValue(taxRateObj));
                cpEntryModel.markPriced(PricingLang.coupleBillPricing());
            }
        }
    }

    private Map<String, SettleBillEntryModel> parseGroupSeq(List<SettleBillModel> billModels) {
        HashMap<String, SettleBillEntryModel> groupSeqMap = new HashMap<String, SettleBillEntryModel>(64);
        for (SettleBillModel billModel : billModels) {
            for (SettleBillEntryModel entryModel : billModel.getEntries()) {
                String groupSeq = (String)entryModel.getValueFromSrcObj("groupseq");
                if (!StringUtils.isNotEmpty((CharSequence)groupSeq)) continue;
                groupSeqMap.put(groupSeq, entryModel);
            }
        }
        return groupSeqMap;
    }

    private String buildKey(CoupleSettleBillsModel cpModel, String groupNumb) {
        return this.buildKey(cpModel.getSupplierId(), cpModel.getDemandId(), groupNumb);
    }

    private String buildKey(Long supplierId, Long demandId, String groupNumb) {
        StringBuilder key = new StringBuilder();
        key.append(supplierId);
        key.append('-');
        key.append(demandId);
        key.append('-');
        key.append(groupNumb);
        return key.toString();
    }
}

