/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.pricing;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.action.impl.pricing.AbstractPriceAdditionAction;
import kd.scmc.ism.common.model.entity.PathPricingTree;
import kd.scmc.ism.common.model.log.PricingTypeLogHandler;
import kd.scmc.ism.common.model.mapper.ExRateCacheMapper;
import kd.scmc.ism.common.model.tree.InfoTreeNode;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;

public class PathPricingAction
extends AbstractPriceAdditionAction {
    @Override
    protected boolean isSkipAction() {
        return this.getReqContext().getPathPrirce().isEmpty();
    }

    @Override
    protected void doAction() {
        PathPricingTree pathPrirce = this.getReqContext().getPathPrirce();
        List<InfoTreeNode<CoupleSettleBillEntriesModel>> roots = pathPrirce.getRoot();
        for (InfoTreeNode<CoupleSettleBillEntriesModel> root : roots) {
            this.doNodePrice(root);
        }
        HashMap<Long, CoupleSettleBillsModel> needWriteToBill = new HashMap<Long, CoupleSettleBillsModel>(16);
        for (InfoTreeNode<CoupleSettleBillEntriesModel> infoTreeNode : pathPrirce.getSubNodes()) {
            CoupleSettleBillsModel billModel = infoTreeNode.getValue().getBillModel();
            needWriteToBill.put(billModel.getId(), billModel);
        }
        for (CoupleSettleBillsModel coupleSettleBillsModel : needWriteToBill.values()) {
            coupleSettleBillsModel.writeToBill();
        }
    }

    private void doNodePrice(InfoTreeNode<CoupleSettleBillEntriesModel> node) {
        ExRateCacheMapper exRateCacheMapper = this.getServiceContext().getService(ExRateCacheMapper.class);
        CoupleSettleBillEntriesModel preEntryModel = node.getValue();
        long preSettleCurrencyId = preEntryModel.getBillModel().getSettleCurrencyId();
        long preUnitId = DynamicObjectUtil.getPkValue((DynamicObject)preEntryModel.getValue("unit"));
        for (InfoTreeNode<CoupleSettleBillEntriesModel> infoTreeNode : node.getAllSubNodes()) {
            Date exrateDate;
            CoupleSettleBillEntriesModel curPriceNode = infoTreeNode.getValue();
            CoupleSettleBillsModel billModel = curPriceNode.getBillModel();
            Long settleCurrencyId = billModel.getSettleCurrencyId();
            if (settleCurrencyId == null) {
                settleCurrencyId = DynamicObjectUtil.getPkValue((DynamicObject)billModel.getValue("settlecy"));
            }
            if ((exrateDate = billModel.getExRateDate()) == null) {
                exrateDate = (Date)billModel.getValue("exratedate");
            }
            if (preEntryModel.getCalPrice() == null || preEntryModel.getCalPriceWithTax() == null) {
                PricingTypeLogHandler pricingLogHandler = this.getReqContext().getPricingLogHandler().getTypeLogHandler("price");
                pricingLogHandler.markSucceededFail(curPriceNode.getId(), PricingLang.priceFail());
                continue;
            }
            curPriceNode.setPriceCurrencyId(preSettleCurrencyId);
            curPriceNode.setPriceUnit(preUnitId);
            curPriceNode.setRePrice(preEntryModel.getCalPrice());
            curPriceNode.setRePriceWithTax(preEntryModel.getCalPriceWithTax());
            this.handlePrcie(exRateCacheMapper, settleCurrencyId, exrateDate, curPriceNode);
            if (infoTreeNode.getAllSubNodes().isEmpty()) continue;
            this.doNodePrice(infoTreeNode);
        }
    }
}

