/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.pricing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.action.impl.pricing.AbstractPricingAction;
import kd.scmc.ism.common.consts.config.SettleLogConsts;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;

public class RedBillPricingAction
extends AbstractPricingAction {
    private static final Log log = LogFactory.getLog(RedBillPricingAction.class);
    private static final String[] QUERY_FIELD = new String[]{"settlecy", "exratedate", "price", "priceandtax", "taxrateid", "unit", "material", "groupnumber", "groupseq", "mainbizorg"};
    private Map<String, Long> supplyPath2BillId = new HashMap<String, Long>();
    private List<CoupleSettleBillsModel> coupleSettleBillsModels = new ArrayList<CoupleSettleBillsModel>();

    @Override
    protected boolean isSkipAction() {
        return super.isSkipAction() || this.coupleBillModelFilter();
    }

    @Override
    protected void doAction() {
        if (!this.coupleSettleBillsModels.isEmpty()) {
            this.execute(this.coupleSettleBillsModels);
        }
    }

    private boolean coupleBillModelFilter() {
        DynamicObject dynamicObject;
        ISMRequestContext reqContext = this.getReqContext();
        String paramValue = reqContext.getBackGroundParamValue("ism_priceredbill");
        if (kd.bos.util.StringUtils.isEmpty((String)paramValue) && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invdbparam", (String)"value", (QFilter[])new QFilter("key", "=", (Object)"ism_priceredbill").toArray())) != null) {
            paramValue = dynamicObject.getString("value");
        }
        boolean getRedBillPrice = false;
        if (kd.bos.util.StringUtils.isNotEmpty((String)paramValue)) {
            paramValue = paramValue.trim().toLowerCase();
            log.info("\u540e\u53f0\u53c2\u6570ism_priceredbill\u7684\u503c\u4e3a\uff1a" + paramValue);
            getRedBillPrice = Boolean.parseBoolean(paramValue);
        }
        if (getRedBillPrice && reqContext != null) {
            List<CoupleSettleBillsModel> supDemBillInfos = reqContext.getSupDemBillInfos();
            for (CoupleSettleBillsModel billModel : supDemBillInfos) {
                DynamicObject settleRelation;
                String bizDirect;
                DynamicObject entrySettleRelation = billModel.getEntrySettleRelation();
                if (entrySettleRelation == null || entrySettleRelation.getParent() == null || !billModel.isPricing() || !"R".equals(bizDirect = (settleRelation = (DynamicObject)entrySettleRelation.getParent()).getString("bizdirect"))) continue;
                this.coupleSettleBillsModels.add(billModel);
            }
        }
        return this.coupleSettleBillsModels.isEmpty();
    }

    private void execute(List<CoupleSettleBillsModel> supDemBillInfos) {
        HashSet<Long> supplyOrgId = new HashSet<Long>(16);
        HashSet<Long> demandOrgId = new HashSet<Long>(16);
        HashSet<String> groupNumValue = new HashSet<String>();
        for (CoupleSettleBillsModel cpModel : supDemBillInfos) {
            String groupNum;
            supplyOrgId.add(cpModel.getSupplierId());
            demandOrgId.add(cpModel.getDemandId());
            SettleBillModel virtualBillModel = cpModel.getSupBillModel() != null ? (SettleBillModel)cpModel.getSupBillModel() : (SettleBillModel)cpModel.getDemBillModel();
            if (virtualBillModel == null || !kd.bos.util.StringUtils.isNotEmpty((String)(groupNum = (String)virtualBillModel.getValue("groupnumber")))) continue;
            groupNumValue.add(groupNum);
        }
        DynamicObjectCollection collection = this.querySettleLog(supplyOrgId, demandOrgId, groupNumValue);
        if (collection == null || collection.isEmpty()) {
            log.info("\u6839\u636e\u6210\u7ec4\u53f7\uff1a" + groupNumValue + "\u6ca1\u6709\u67e5\u8be2\u5230\u7ed3\u7b97\u8def\u5f84\u4e3a\u6b63\u5411\u7684\u7ed3\u7b97\u8bb0\u5f55");
            return;
        }
        HashMap<String, Set<Long>> billType2Id = new HashMap<String, Set<Long>>(16);
        for (DynamicObject logEntry : collection) {
            Long settleBillId = logEntry.getLong("settlebillid");
            String settleBillType = logEntry.getString("settlebilltype");
            String groupNumber = logEntry.getString("groupnumber");
            Long curSupplyOrgId = logEntry.getLong("esupsettleorg");
            Long curDemandOrgId = logEntry.getLong("edemandorg");
            String key = this.buildKey(curSupplyOrgId, curDemandOrgId, groupNumber);
            if (this.supplyPath2BillId.containsKey(key)) continue;
            CommonUtils.mapGetSetValue(billType2Id, settleBillType).add(settleBillId);
            this.supplyPath2BillId.put(key, settleBillId);
        }
        Map<Long, SettleBillModel> blueSrcBillModel = this.buildGroupBillModel(billType2Id);
        this.setCoupleBillValue(blueSrcBillModel, supDemBillInfos);
    }

    private DynamicObjectCollection querySettleLog(Set<Long> supplyOrgId, Set<Long> demandOrgId, Set<String> groupNum) {
        if (groupNum.isEmpty()) {
            return null;
        }
        String queryFields = SettleLogConsts.buildEntryFields("settlebilltype", "settlebillid", "edemandorg", "esupsettleorg", "groupnumber");
        QFilter settleLogFilter = new QFilter("entryentity.groupnumber", "in", groupNum).and("entryentity.esupsettleorg", "in", supplyOrgId).and("entryentity.edemandorg", "in", demandOrgId).and("entryentity.settlerelation.bizdirect", "=", (Object)"B");
        return QueryServiceHelper.query((String)"ism_settlelog", (String)queryFields, (QFilter[])settleLogFilter.toArray(), (String)"createdate desc");
    }

    private String buildKey(long supplyOrg, long demandOrg, String groupNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append(supplyOrg).append('-');
        sb.append(demandOrg).append('-');
        sb.append(groupNumber);
        return sb.toString();
    }

    private Map<Long, SettleBillModel> buildGroupBillModel(Map<String, Set<Long>> billType2Id) {
        HashMap<Long, SettleBillModel> groupBillModel = new HashMap<Long, SettleBillModel>(16);
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        for (Map.Entry<String, Set<Long>> entry : billType2Id.entrySet()) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = this.querySrcSettleBillInfo(entry.getKey(), entry.getValue())) {
                groupBillModel.put(DynamicObjectUtil.getPkValue(bill), SettleBillModel.build(bill, mapCfg));
            }
        }
        return groupBillModel;
    }

    private DynamicObject[] querySrcSettleBillInfo(String entryNumber, Set<Long> ids) {
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("id");
        fields.add(mapCfg.getFieldKey(entryNumber, "billentry").concat(".").concat("id"));
        for (String queryField : QUERY_FIELD) {
            String fieldInfo = mapCfg.getFieldSrcKey(entryNumber, queryField);
            if (!StringUtils.isNotEmpty((CharSequence)fieldInfo)) continue;
            fields.add(fieldInfo);
        }
        return BusinessDataServiceHelper.load((String)entryNumber, (String)CommonUtils.transToStr(fields), (QFilter[])new QFilter("id", "in", ids).toArray());
    }

    private void setCoupleBillValue(Map<Long, SettleBillModel> blueSrcBillModel, List<CoupleSettleBillsModel> supDemBillInfos) {
        StringBuilder priceLog = new StringBuilder();
        for (CoupleSettleBillsModel cpModel : supDemBillInfos) {
            SettleBillModel srcSupModel;
            Long demandOrgId = cpModel.getDemandId();
            Long supplyOrgId = cpModel.getSupplierId();
            String groupNumber = this.getGroupNumberByModel(cpModel);
            String supKey = this.buildKey(supplyOrgId, demandOrgId, groupNumber);
            Long curSupBillId = this.supplyPath2BillId.get(supKey);
            if (curSupBillId == null || (srcSupModel = blueSrcBillModel.get(curSupBillId)) == null) continue;
            this.setValue(srcSupModel, cpModel, priceLog);
            priceLog.append("\n");
        }
        log.info("\u7ea2\u5355\u53d6\u5bf9\u5e94\u7684\u84dd\u5355\u4ef7\u683c\u4fe1\u606f\uff1a" + priceLog);
    }

    private String getGroupNumberByModel(CoupleSettleBillsModel cpModel) {
        SettleBillModel billModel;
        SettleBillModel settleBillModel = billModel = cpModel.getSupBillModel() != null ? (SettleBillModel)cpModel.getSupBillModel() : (SettleBillModel)cpModel.getDemBillModel();
        if (billModel != null) {
            return this.getGroupNumberByEntryModel(billModel);
        }
        return null;
    }

    private String getGroupNumberByEntryModel(SettleBillModel model) {
        List<SettleBillEntryModel> entryModels = model.getEntries();
        if (!entryModels.isEmpty()) {
            return (String)entryModels.get(0).getValue("groupnumber");
        }
        return null;
    }

    private void setValue(SettleBillModel srcSupBillModel, CoupleSettleBillsModel cpModel, StringBuilder priceLog) {
        DynamicObject settleCurrency = (DynamicObject)srcSupBillModel.getValueFromSrcObj("settlecy");
        Long currencyId = DynamicObjectUtil.getPkValue(settleCurrency);
        cpModel.setSettleCurrencyId(currencyId);
        Date date = (Date)srcSupBillModel.getValueFromSrcObj("exratedate");
        cpModel.setExRateDate(date);
        priceLog.append("settlecurrency\uff1a").append(currencyId).append("\uff0c").append("exrateData\uff1a").append(date).append("\n");
        cpModel.markPriced(PricingLang.priceBlueBill());
        this.setEntryValue(srcSupBillModel, settleCurrency, cpModel, priceLog);
    }

    private void setEntryValue(SettleBillModel srcSupBillModel, DynamicObject settleCurrency, CoupleSettleBillsModel cpModel, StringBuilder priceLog) {
        Map<String, SettleBillEntryModel> supMap = this.parseGroupSeq(srcSupBillModel);
        for (CoupleSettleBillEntriesModel cpEntryModel : cpModel.getEntries()) {
            String groupSeq = (String)cpEntryModel.getValue("groupseq");
            SettleBillEntryModel entryModel = supMap.get(groupSeq);
            if (entryModel == null) continue;
            BigDecimal priceTax = (BigDecimal)entryModel.getValueFromSrcObj("priceandtax");
            BigDecimal price = (BigDecimal)entryModel.getValueFromSrcObj("price");
            Long priceUnit = DynamicObjectUtil.getPkValue((DynamicObject)entryModel.getValue("unit"));
            cpEntryModel.setPriceUnit(priceUnit);
            if (priceTax == null) {
                priceTax = price;
            }
            if (price == null) {
                price = priceTax;
            }
            cpEntryModel.setPriceCurrencyId(DynamicObjectUtil.getPkValue(settleCurrency));
            cpEntryModel.setRePriceWithTax(priceTax);
            cpEntryModel.setRePrice(price);
            DynamicObject taxRateObj = (DynamicObject)entryModel.getValueFromSrcObj("taxrateid");
            cpEntryModel.setTaxRateId(DynamicObjectUtil.getPkValue(taxRateObj));
            priceLog.append("entryId\uff1a").append(entryModel.getObj().getPkValue()).append("\uff0c").append("price\uff1a").append(price).append("\uff0c").append("priceAndTax\uff1a").append(priceTax).append("\n");
            cpEntryModel.markPriced(PricingLang.priceBlueBill());
        }
    }

    private Map<String, SettleBillEntryModel> parseGroupSeq(SettleBillModel billModel) {
        HashMap<String, SettleBillEntryModel> groupSeqMap = new HashMap<String, SettleBillEntryModel>(16);
        for (SettleBillEntryModel entryModel : billModel.getEntries()) {
            String groupSeq = (String)entryModel.getValueFromSrcObj("groupseq");
            if (!StringUtils.isNotEmpty((CharSequence)groupSeq)) continue;
            groupSeqMap.put(groupSeq, entryModel);
        }
        return groupSeqMap;
    }
}

