/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.pricing;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.business.action.impl.pricing.AbstractPriceAdditionAction;
import kd.scmc.ism.common.model.assist.OrgAssistant;
import kd.scmc.ism.common.model.mapper.DynamicObjectCacheMapper;
import kd.scmc.ism.common.model.mapper.ExRateCacheMapper;
import kd.scmc.ism.common.model.mapper.MaterialUnitConvertMapper;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;

public class ValueWriteBackAction
extends AbstractPriceAdditionAction {
    @Override
    protected void doAction() {
        this.batchLoadData();
        this.coupleBillValueWriteBack();
    }

    private void batchLoadData() {
        List<CoupleSettleBillsModel> cpBillModels = this.getReqContext().getSupDemBillInfos();
        HashSet<Object> currencyIds = new HashSet<Object>(16);
        HashSet<Object> taxRateIds = new HashSet<Object>(16);
        HashSet<Long> matIds = new HashSet<Long>(16);
        for (CoupleSettleBillsModel cpBillsModel : cpBillModels) {
            currencyIds.add(cpBillsModel.getSettleCurrencyId());
            List<CoupleSettleBillEntriesModel> entries = cpBillsModel.getEntries();
            for (CoupleSettleBillEntriesModel cpEntryModel : entries) {
                currencyIds.add(cpEntryModel.getPriceCurrencyId());
                taxRateIds.add(cpEntryModel.getTaxRateId());
                if (!cpEntryModel.isUnitConvert()) continue;
                Long matId = DynamicObjectUtil.getMaterialMasterId((DynamicObject)cpEntryModel.getValue("material"));
                matIds.add(matId);
            }
        }
        DynamicObjectCacheMapper doMapper = this.getServiceContext().getService(DynamicObjectCacheMapper.class);
        doMapper.load("bd_currency", currencyIds);
        doMapper.load("bd_taxrate", taxRateIds);
        if (!matIds.isEmpty()) {
            MaterialUnitConvertMapper unitConvertMapper = this.getServiceContext().getService(MaterialUnitConvertMapper.class);
            unitConvertMapper.load(matIds);
        }
    }

    private void coupleBillValueWriteBack() {
        DynamicObjectCacheMapper doMapper = this.getServiceContext().getService(DynamicObjectCacheMapper.class);
        ExRateCacheMapper exRateService = this.getServiceContext().getService(ExRateCacheMapper.class);
        OrgAssistant orgAssistant = this.getServiceContext().getOrgAssistant();
        List<CoupleSettleBillsModel> cpBillModels = this.getReqContext().getSupDemBillInfos();
        for (CoupleSettleBillsModel cpBillsModel : cpBillModels) {
            SettleBillModel srcBillModel = (SettleBillModel)cpBillsModel.getSrcBillModel();
            srcBillModel.initExrateTable(orgAssistant);
            Long settleCurrencyId = cpBillsModel.getSettleCurrencyId();
            DynamicObject settleCurrency = doMapper.get("bd_currency", settleCurrencyId);
            if (settleCurrency != null) {
                cpBillsModel.setValue("settlecy", settleCurrency);
            } else {
                settleCurrency = (DynamicObject)cpBillsModel.getValue("settlecy");
                settleCurrencyId = DynamicObjectUtil.getPkValue(settleCurrency);
            }
            Date exrateDate = cpBillsModel.getExRateDate();
            if (exrateDate != null) {
                cpBillsModel.setValue("exratedate", exrateDate);
            } else {
                exrateDate = (Date)cpBillsModel.getValue("exratedate");
            }
            for (SettleBillModel billModel : cpBillsModel.getModels()) {
                billModel.initExrateTable(orgAssistant);
                long baseCurrencyId = billModel.getBaseCurrencyId();
                DynamicObject baseCurrency = doMapper.get("bd_currency", baseCurrencyId);
                billModel.setValue("basecurrency", baseCurrency);
                long exRateTableId = billModel.getExRateTableId();
                billModel.setValue("exratetable", DynamicObjectUtil.buildObject("bd_exratetable", exRateTableId));
                if (settleCurrency == null) continue;
                String quotation = exRateService.getQuotation(exRateTableId, settleCurrencyId, baseCurrencyId, exrateDate);
                billModel.setValue("quotation", quotation);
                BigDecimal exRate = exRateService.getExRate(exRateTableId, settleCurrencyId, baseCurrencyId, exrateDate);
                if (exRate == null) continue;
                billModel.setValue("exchangerate", exRate);
            }
            List<CoupleSettleBillEntriesModel> entries = cpBillsModel.getEntries();
            for (CoupleSettleBillEntriesModel cpEntryModel : entries) {
                long taxRateId = cpEntryModel.getTaxRateId();
                DynamicObject taxReate = doMapper.get("bd_taxrate", taxRateId);
                if (taxReate != null) {
                    cpEntryModel.setValue("taxrateid", taxReate);
                    cpEntryModel.setValue("taxrate", taxReate.getBigDecimal("taxrate"));
                }
                if (this.getReqContext().getPathPrirce().isContain(cpEntryModel)) continue;
                this.handlePrcie(exRateService, settleCurrencyId, exrateDate, cpEntryModel);
            }
            cpBillsModel.writeToBill();
        }
    }
}

