/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.action.impl.vali;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.action.AbstractSettleAction;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.PlainObjBillModel;
import kd.scmc.ism.model.match.engine.impl.SettleJudgeMatchEngine;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.entity.MatchResult;

public class SettleJudgeAction
extends AbstractSettleAction {
    private SettleJudgeMatchEngine engine = SettleJudgeMatchEngine.build(new String[0]);

    @Override
    protected void doAction() {
        ISMRequestContext reqContext = this.getReqContext();
        Map<String, Set<Long>> reqBillIds = reqContext.getReqBillIds();
        for (Map.Entry<String, Set<Long>> entry : reqBillIds.entrySet()) {
            String billEntityType = entry.getKey();
            Set<Long> billIds = entry.getValue();
            DynamicObjectCollection billInfoObjs = this.queryBillInfos(billEntityType, billIds);
            for (DynamicObject billInfoObj : billInfoObjs) {
                PlainObjBillModel billModel = new PlainObjBillModel(billInfoObj, billEntityType);
                reqContext.addSrcPlainObj(billModel);
                MatchArgs matchArgs = MatchArgs.buildMatch(billModel);
                MatchResult doSJMatch = this.engine.doMatch(matchArgs);
                if (!doSJMatch.isMatch()) continue;
                reqContext.putMatchResult(billModel.getId(), doSJMatch);
            }
        }
    }

    private DynamicObjectCollection queryBillInfos(String billEntityType, Set<Long> billIds) {
        HashSet<String> allDimField = new HashSet<String>(16);
        Set<String> sjfields = this.engine.getAllFilterField().get(billEntityType);
        if (CommonUtils.collectionIsNotEmpty(sjfields)) {
            allDimField.addAll(sjfields);
        }
        allDimField.add("id");
        String selectFields = CommonUtils.transToStr(allDimField);
        DynamicObjectCollection billInfoObjs = QueryServiceHelper.query((String)billEntityType, (String)selectFields, (QFilter[])new QFilter("id", "in", billIds).toArray());
        return billInfoObjs;
    }
}

