/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.func;

import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.business.func.IConditionFunction;
import kd.scmc.ism.business.func.impl.DifferentLegalPersonCFunc;
import kd.scmc.ism.business.func.impl.SameLegalPersonCFunc;
import kd.scmc.ism.model.match.entity.MatchArgs;

public class ConditionFunctionManager {
    public static final Log log = LogFactory.getLog(ConditionFunctionManager.class);
    private Map<String, IConditionFunction> loadedFunctios = new HashMap<String, IConditionFunction>(16);

    private ConditionFunctionManager() {
    }

    public static ConditionFunctionManager create() {
        ConditionFunctionManager manager = new ConditionFunctionManager();
        manager.loadPreinFunction();
        return manager;
    }

    public boolean doExeucte(MatchArgs args, String functionKey) {
        IConditionFunction function = this.loadedFunctios.get(functionKey);
        if (function == null) {
            log.error("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u6761\u4ef6\u5224\u65ad\u51fd\u6570\u672a\u52a0\u8f7d\u5230\u5bf9\u5e94\u5b9e\u73b0\uff1a" + functionKey);
            return false;
        }
        try {
            return function.doExeucte(args);
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u6761\u4ef6\u5224\u65ad\u51fd\u6570\u9519\u8bef\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return false;
        }
    }

    private void loadPreinFunction() {
        this.addFucntion(new SameLegalPersonCFunc());
        this.addFucntion(new DifferentLegalPersonCFunc());
    }

    private void addFucntion(IConditionFunction function) {
        this.loadedFunctios.put(function.funcKey(), function);
    }
}

