/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.common.model.IsmBizContext;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;
import kd.scmc.ism.common.model.mapper.CurrencyAndExRateTableCacheMapper;
import kd.scmc.ism.common.model.mapper.DynamicObjectCacheMapper;
import kd.scmc.ism.common.model.mapper.ExRateCacheMapper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;

public class BillBusinessHelper {
    public static Map<Long, DynamicObject> getBillObjs(Map<String, Set<Long>> entityToIds) {
        HashMap<Long, DynamicObject> billObjs = new HashMap<Long, DynamicObject>(128);
        for (Map.Entry<String, Set<Long>> entryInfo : entityToIds.entrySet()) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = BillBusinessHelper.getSimpleBillInfo(entryInfo.getKey(), (Collection<Long>)entryInfo.getValue())) {
                billObjs.put(DynamicObjectUtil.getPkValue(bill), bill);
            }
        }
        return billObjs;
    }

    public static Map<Long, String> getBillStatusInfo(Map<String, Set<Long>> entityToIds) {
        HashMap<Long, String> billStatusInfo = new HashMap<Long, String>(128);
        for (Map.Entry<String, Set<Long>> entryInfo : entityToIds.entrySet()) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = BillBusinessHelper.getSimpleBillInfo(entryInfo.getKey(), (Collection<Long>)entryInfo.getValue())) {
                billStatusInfo.put(DynamicObjectUtil.getPkValue(bill), bill.getString("billstatus"));
            }
        }
        return billStatusInfo;
    }

    public static DynamicObject[] getSimpleBillInfo(String billentityType, QFilter filter) {
        BillEntityType entityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)billentityType);
        String selectProps = "id," + entityType.getBillStatus() + "," + entityType.getMainOrg() + "," + entityType.getBillNo();
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)billentityType, (String)selectProps, (QFilter[])filter.toArray());
        return bills;
    }

    public static DynamicObject[] getSimpleBillInfo(String billentityType, Collection<Long> billIds) {
        return BillBusinessHelper.getSimpleBillInfo(billentityType, new QFilter("id", "in", billIds));
    }

    public static void handleBillCurInfo(DynamicObject bill, IsmBizContext bizContext) {
        if (bill == null) {
            return;
        }
        DynamicObjectCacheMapper objectMapper = bizContext.getService(DynamicObjectCacheMapper.class);
        CurrencyAndExRateTableCacheMapper currencyAndExrateMapper = bizContext.getService(CurrencyAndExRateTableCacheMapper.class);
        ExRateCacheMapper exRateMapper = bizContext.getService(ExRateCacheMapper.class);
        BillFieldMapCfg billFieldMap = bizContext.getBillFieldMap();
        MainEntityType billentityType = (MainEntityType)bill.getDynamicObjectType();
        String entityType = billentityType.getName();
        Map<String, String> srcBillDataMap = billFieldMap.getSrcBillDataMap(entityType);
        String mainOrgKey = billentityType.getMainOrg();
        String basCurrencyKey = srcBillDataMap.get("basecurrency");
        String exRateTableKey = srcBillDataMap.get("exratetable");
        String settleCurrencyKey = srcBillDataMap.get("settlecy");
        String exRateDateKey = srcBillDataMap.get("exratedate");
        String exRateKey = srcBillDataMap.get("exchangerate");
        if (StringUtils.isEmpty((CharSequence)basCurrencyKey) || StringUtils.isEmpty((CharSequence)settleCurrencyKey) || StringUtils.isEmpty((CharSequence)exRateKey) || StringUtils.isEmpty((CharSequence)mainOrgKey) || StringUtils.isEmpty((CharSequence)exRateDateKey)) {
            return;
        }
        DynamicObject settleCurrency = bill.getDynamicObject(settleCurrencyKey);
        long settleCurrencyId = DynamicObjectUtil.getPkValue(settleCurrency);
        DynamicObject mainBizOrg = bill.getDynamicObject(billentityType.getMainOrg());
        long mainBizOrgId = DynamicObjectUtil.getPkValue(mainBizOrg);
        Map<String, Long> currencyAndExrateTable = currencyAndExrateMapper.get(mainBizOrgId);
        if (CommonUtils.mapIsEmpty(currencyAndExrateTable)) {
            return;
        }
        Long baseCurrencyId = currencyAndExrateTable.get("baseCurrencyID");
        Long exrateTableId = currencyAndExrateTable.get("exchangeRateTableID");
        Date exrateDate = bill.getDate(exRateDateKey);
        BigDecimal exRate = exRateMapper.getExRate(exrateTableId, settleCurrencyId, baseCurrencyId, exrateDate);
        bill.set(exRateKey, (Object)exRate);
        bill.set(basCurrencyKey, (Object)objectMapper.get("bd_currency", baseCurrencyId));
        if (StringUtils.isNotEmpty((CharSequence)exRateTableKey)) {
            bill.set(exRateTableKey, (Object)objectMapper.get("bd_exratetable", exrateTableId));
        }
    }
}

