/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.util.DataTypeMapper;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;
import kd.scmc.ism.common.model.entity.ModelFilter;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.lang.ReportLang;
import org.apache.commons.lang3.StringUtils;

public class BillModelDataSetHelper {
    private static final String[] IM_MDC_BILL_NUMBER = new String[]{"im_mdc_omfeedbill", "im_mdc_omoutbill", "im_mdc_omreturnbill", "im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_mftmanuinbill", "im_mdc_mftreturnbill", "im_mdc_omproorder", "im_mdc_omreturnorder", "im_mdc_omfeedorder"};

    public static DataSet parallelGetData(Map<String, Set<Long>> billIdsMap, BillFieldMapCfg fieldMapCfg, String[] queryfields) {
        return BillModelDataSetHelper.parallelGetDataWithModelFilter(billIdsMap, fieldMapCfg, queryfields, new ArrayList<ModelFilter>(0));
    }

    public static DataSet parallelGetDataWithModelFilter(Map<String, Set<Long>> billIdsMap, BillFieldMapCfg fieldMapCfg, String[] queryfields, List<ModelFilter> modelfilters) {
        HashMap<String, QFilter> billFilters = new HashMap<String, QFilter>(billIdsMap.size());
        for (Map.Entry<String, Set<Long>> billEntity : billIdsMap.entrySet()) {
            billFilters.put(billEntity.getKey(), new QFilter("id", "in", billEntity.getValue()));
        }
        return BillModelDataSetHelper.parallelGetDataWithModelFilter(billIdsMap.keySet(), fieldMapCfg, queryfields, modelfilters, billFilters);
    }

    public static DataSet parallelGetDataWithModelFilter(Set<String> billTypes, BillFieldMapCfg fieldMapCfg, String[] queryfields, List<ModelFilter> modelFilter) {
        return BillModelDataSetHelper.parallelGetDataWithModelFilter(billTypes, fieldMapCfg, queryfields, modelFilter, new HashMap<String, QFilter>(0));
    }

    private static DataSet parallelGetDataWithModelFilter(Set<String> billTypes, BillFieldMapCfg fieldMapCfg, String[] queryfields, List<ModelFilter> modelFilter, Map<String, QFilter> specBillFilter) {
        String algoKey = "ismParallelGetData";
        RowMeta buildRowMeta = BillModelDataSetHelper.buildRowMeta(queryfields, fieldMapCfg);
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(billTypes.size());
        for (String billtype : billTypes) {
            QFilter specQFilter;
            List<QFilter> qFilters = BillModelDataSetHelper.buildQFilters(billtype, modelFilter, fieldMapCfg);
            if (CommonUtils.mapIsNotEmpty(specBillFilter) && (specQFilter = specBillFilter.get(billtype)) != null) {
                qFilters.add(specQFilter);
            }
            String selectFieldsStr = BillModelDataSetHelper.buildSelectFieldsStr(billtype, queryfields, fieldMapCfg);
            OrmInput billIO = new OrmInput(algoKey + "-" + billtype, billtype, selectFieldsStr, qFilters.toArray(new QFilter[qFilters.size()]), buildRowMeta);
            billsIO.add(billIO);
        }
        if (billsIO.isEmpty()) {
            return null;
        }
        Algo algo = Algo.create((String)algoKey);
        DataSet billsData = algo.createDataSet((Input[])billsIO.toArray(new OrmInput[billsIO.size()]));
        return billsData;
    }

    private static RowMeta buildRowMeta(String[] queryfields, BillFieldMapCfg fieldMapCfg) {
        BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("billid", (DataType)DataType.LongType));
        fields.add(new Field("billno", (DataType)DataType.StringType));
        fields.add(new Field("billentitytype", (DataType)DataType.StringType));
        for (String string : queryfields) {
            IDataEntityProperty findProperty = dataEntityType.findProperty(string);
            if (findProperty instanceof BasedataProp) {
                fields.add(new Field(string, (DataType)DataType.LongType));
                continue;
            }
            if (findProperty instanceof TextProp || findProperty instanceof ComboProp) {
                fields.add(new Field(string, (DataType)DataType.StringType));
                continue;
            }
            if (findProperty instanceof TimeProp) {
                fields.add(new Field(string, (DataType)DataType.TimestampType));
                continue;
            }
            if (findProperty instanceof DateProp) {
                fields.add(new Field(string, (DataType)DataType.DateType));
                continue;
            }
            if (findProperty instanceof BooleanProp) {
                fields.add(new Field(string, (DataType)DataType.BooleanType));
                continue;
            }
            fields.add(new Field(string, DataTypeMapper.get((Class)findProperty.getPropertyType())));
        }
        RowMeta rowMeta = new RowMeta(fields.toArray(new Field[fields.size()]));
        return rowMeta;
    }

    private static String buildSelectFieldsStr(String entity, String[] queryfields, BillFieldMapCfg fieldMapCfg) {
        BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
        return BillModelDataSetHelper.buildSelectFieldsStr(entity, queryfields, fieldMapCfg, dataEntityType);
    }

    private static String buildSelectFieldsStr(String entity, String[] queryfields, BillFieldMapCfg fieldMapCfg, BasedataEntityType billModelEntity) {
        BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        Map<String, String> srcBillDataMap = fieldMapCfg.getSrcBillDataMap(entity);
        if (srcBillDataMap == null) {
            throw new KDBizException(ModelLang.notConfigMapping(billEntityType.getDisplayName().getLocaleValue()));
        }
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add(billEntityType.getPrimaryKey().getName() + " as billid");
        selectFields.add(billEntityType.getBillNo() + " as billno");
        selectFields.add("'" + entity + "' as billentitytype");
        ArrayList<IDataEntityProperty> notConfigProp = new ArrayList<IDataEntityProperty>(16);
        for (String queryField : queryfields) {
            String billField = srcBillDataMap.get(queryField);
            IDataEntityProperty modelProp = billModelEntity.findProperty(queryField);
            if (modelProp == null) continue;
            if (StringUtils.isEmpty((CharSequence)billField)) {
                if (modelProp instanceof BasedataProp || modelProp instanceof DecimalProp) {
                    selectFields.add("0 as " + queryField);
                    continue;
                }
                if (modelProp instanceof TextProp) {
                    selectFields.add("'' as " + queryField);
                    continue;
                }
                if (modelProp instanceof TimeProp) {
                    selectFields.add("'' as " + queryField);
                    continue;
                }
                if (modelProp instanceof DateProp) {
                    selectFields.add("null as " + queryField);
                    continue;
                }
                notConfigProp.add(modelProp);
                continue;
            }
            selectFields.add(billField + " as " + queryField);
        }
        if (!notConfigProp.isEmpty()) {
            throw new KDBizException(ReportLang.noConfigBillFieldMapping(billEntityType, notConfigProp));
        }
        String fields = ((Object)selectFields).toString();
        return fields.substring(1, fields.length() - 1);
    }

    private static List<QFilter> buildQFilters(String entity, List<ModelFilter> modelFilters, BillFieldMapCfg fieldMapCfg) {
        ArrayList<QFilter> billFilter = new ArrayList<QFilter>(16);
        for (ModelFilter modelfilter : modelFilters) {
            String propValue = modelfilter.getProperty();
            if ("bookdate".equals(propValue) && StringUtils.isEmpty((CharSequence)fieldMapCfg.getSrcFieldNum(entity, "bookdate"))) {
                propValue = "biztime";
            }
            String srcFieldNum = fieldMapCfg.getSrcFieldNum(entity, propValue);
            if ("isvirtualbill".equals(propValue) && Boolean.TRUE.equals(modelfilter.getValue()) && StringUtils.isEmpty((CharSequence)fieldMapCfg.getSrcFieldNum(entity, propValue))) {
                return Collections.singletonList(CommonFilterHelper.getEmptyFilter());
            }
            if ("ap_finapbill".equals(entity) && ("srcbillid".equals(propValue) || "srcbillentryid".equals(propValue)) && srcFieldNum != null) {
                IDataEntityProperty property;
                String[] split = srcFieldNum.split("\\.");
                String field = srcFieldNum;
                if (split.length > 1) {
                    field = split[split.length - 1];
                }
                if ((property = EntityMetadataCache.getDataEntityType((String)entity).findProperty(field)) instanceof TextProp) {
                    Object srcValue = modelfilter.getValue();
                    if (srcValue instanceof Collection) {
                        Collection values = (Collection)modelfilter.getValue();
                        HashSet<String> newIds = new HashSet<String>(16);
                        for (Object value : values) {
                            newIds.add(String.valueOf(value));
                        }
                        modelfilter = new ModelFilter(propValue, modelfilter.getCp(), newIds);
                    } else if ("is not null".equals(modelfilter.getCp())) {
                        modelfilter = new ModelFilter(srcFieldNum, "!=", "");
                    }
                }
            }
            QFilter filter = StringUtils.isNotEmpty((CharSequence)srcFieldNum) ? new QFilter(srcFieldNum, modelfilter.getCp(), modelfilter.getValue()) : CommonFilterHelper.getEmptyFilter();
            billFilter.add(filter);
        }
        if (Arrays.asList(IM_MDC_BILL_NUMBER).contains(entity)) {
            billFilter.add(new QFilter("billentity", "=", (Object)entity));
        }
        return billFilter;
    }
}

