/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.helper.JobHelper;
import kd.scmc.ism.common.model.entity.BillExecuteInfo;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.task.ExecuteBizFlowTask;

public class BizFlowServiceHelper {
    public static final Log log = LogFactory.getLog(BizFlowServiceHelper.class);

    private static Set<String> longsToStrs(Collection<Long> billIds) {
        if (CommonUtils.collectionIsEmpty(billIds)) {
            return new HashSet<String>(0);
        }
        HashSet<String> billIdStrs = new HashSet<String>(billIds.size());
        for (Long billId : billIds) {
            billIdStrs.add(String.valueOf(billId));
        }
        return billIdStrs;
    }

    public static boolean isRunningBizFlow(String billidStr, String flowKey) {
        boolean exists = QueryServiceHelper.exists((String)"wf_execution_tree", (QFilter[])new QFilter("businesskey", "=", (Object)billidStr).toArray());
        return exists;
    }

    public static boolean isFinishedBizFlow(String billidStr, String flowKey) {
        boolean exists = QueryServiceHelper.exists((String)"bpm_historicalprocess", (QFilter[])new QFilter("businesskey", "=", (Object)billidStr).toArray());
        return exists;
    }

    public static List<String> getRunningBizFlowByBillIds(List<String> billIds) {
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"wf_execution_tree", (String)"businesskey", (QFilter[])new QFilter("businesskey", "in", billIds).toArray());
        ArrayList<String> runningbillIds = new ArrayList<String>(objs.size());
        for (DynamicObject obj : objs) {
            runningbillIds.add(obj.getString("businesskey"));
        }
        return runningbillIds;
    }

    public static List<String> getFinishedBizFlowByBillIds(List<String> billIds) {
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"bpm_historicalprocess", (String)"businesskey", (QFilter[])new QFilter("businesskey", "in", billIds).toArray());
        ArrayList<String> finishedBillIds = new ArrayList<String>(objs.size());
        for (DynamicObject obj : objs) {
            finishedBillIds.add(obj.getString("businesskey"));
        }
        return finishedBillIds;
    }

    public static Boolean isInProcess(String businessKey) {
        return (Boolean)DispatchServiceHelper.invokeBOSService((String)"wf", (String)"IWorkflowService", (String)"inProcess", (Object[])new Object[]{businessKey});
    }

    public static Map<Long, String> getBizTraceNos(Collection<Long> billIds) {
        Set<String> billIdStrs = BizFlowServiceHelper.longsToStrs(billIds);
        DynamicObjectCollection queryObjs = QueryServiceHelper.query((String)"wf_circulaterelation", (String)"businesskey, biztraceno", (QFilter[])new QFilter("businesskey", "in", billIdStrs).toArray());
        if (CommonUtils.collectionIsEmpty(queryObjs)) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> hasExecutionIds = new HashMap<Long, String>(queryObjs.size());
        for (DynamicObject queryObj : queryObjs) {
            hasExecutionIds.put(Long.valueOf(queryObj.getString("businesskey")), queryObj.getString("biztraceno"));
        }
        return hasExecutionIds;
    }

    public static Set<Long> getBizFlowExecutionByIds(Collection<Long> billIds) {
        Set<String> billIdStrs = BizFlowServiceHelper.longsToStrs(billIds);
        DynamicObjectCollection queryObjs = QueryServiceHelper.query((String)"wf_execution_tree", (String)"businesskey, suspensionstate", (QFilter[])new QFilter("businesskey", "in", billIdStrs).toArray());
        if (CommonUtils.collectionIsEmpty(queryObjs)) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> hasExecutionIds = new HashSet<Long>(queryObjs.size());
        for (DynamicObject queryObj : queryObjs) {
            hasExecutionIds.add(Long.valueOf(queryObj.getString("businesskey")));
        }
        return hasExecutionIds;
    }

    public static void triggerBizFlow(String billType, String billId, String flowNumber, Map<String, Object> param) throws KDBizException {
        if (param == null) {
            param = new HashMap<String, Object>(1);
        }
        param.put("autoCreateSourceRelation", Boolean.TRUE);
        log.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u6267\u884c\u4e1a\u52a1\u6d41\u7a0b\uff1a\u5355\u636e\u7c7b\u578b\u3010%s\u3011, \u5355\u636eID\u3010%s\u3011, \u4e1a\u52a1\u6d41\u7a0b\u6807\u8bc6\u3010%s\u3011, \u4e1a\u52a1\u53c2\u6570\u3010%s\u3011\n", billType, billId, flowNumber, param));
        DispatchServiceHelper.invokeBOSService((String)"wf", (String)"IWorkflowService", (String)"tryTriggerProcessByProcNumber", (Object[])new Object[]{billId, flowNumber, billType, param});
        log.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u6267\u884c\u4e1a\u52a1\u6d41\u7a0b\uff1a\u5355\u636eID\u3010%s\u3011", billId));
    }

    public static void triggerBizFlow(BillExecuteInfo billExecInfo, Map<String, Object> param) throws KDBizException {
        BizFlowServiceHelper.triggerBizFlow(billExecInfo.getBillEntityType(), String.valueOf(billExecInfo.getBillId()), billExecInfo.getBizFlowKey(), param);
    }

    public static void triggerBizFlowAsync(BillExecuteInfo billExecInfo, Map<String, Object> param) {
        JobInfo bizFlowJob = BizFlowServiceHelper.buildBizFlowJob(billExecInfo.getBillEntityType(), String.valueOf(billExecInfo.getBillId()), billExecInfo.getBizFlowKey(), param);
        JobClient.dispatch((JobInfo)bizFlowJob);
    }

    private static JobInfo buildBizFlowJob(String billType, String billId, String flowNumber, Map<String, Object> param) {
        HashMap<String, String> jobParam = new HashMap<String, String>(4);
        jobParam.put("entityType", billType);
        jobParam.put("id", billId);
        jobParam.put("bizFlowKey", flowNumber);
        jobParam.put("params", SerializationUtils.toJsonString(param));
        JobInfo jobInfo = JobHelper.getJobInfo(ExecuteBizFlowTask.class, null);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setParams(jobParam);
        jobInfo.setRunConcurrently(true);
        return jobInfo;
    }
}

