/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class CurrencyHelper {
    private static final Log log = LogFactory.getLog(CurrencyHelper.class);
    public static final String CURRENCY_DT = "bd_currency";
    public static final String EXRATETABLE_DT = "bd_exratetable";
    public static final String BASECURRRENCY = "baseCurrencyID";
    public static final String EXRATETABLE = "exchangeRateTableID";
    public static final String EXRATE_DT = "bd_exrate_tree";
    public static final String EXRATE_ORGCUR = "orgcur";
    public static final String EXRATE_CUR = "cur";
    public static final String EXRATE_EXCTABLE = "exctable";
    public static final String EXRATE_EXCVAL = "excval";

    private CurrencyHelper() {
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        if (orgId == null || orgId.equals(0L)) {
            return null;
        }
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (mapOrg == null || mapOrg.get("id") == null) {
            return null;
        }
        log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + mapOrg);
        Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
        if (map == null || map.isEmpty()) {
            return null;
        }
        log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a" + map);
        return map;
    }

    public static BigDecimal exrateExchange(BigDecimal srcDecimal, String exhangeType, BigDecimal exChangeRate) {
        return CurrencyHelper.exrateExchange(srcDecimal, exhangeType, exChangeRate, 10);
    }

    public static BigDecimal exrateExchange(BigDecimal srcDecimal, String exhangeType, BigDecimal exChangeRate, int precision) {
        if ("1".equals(exhangeType)) {
            if (exChangeRate == null || BigDecimal.ZERO.compareTo(exChangeRate) == 0) {
                return BigDecimal.ZERO;
            }
            return srcDecimal.divide(exChangeRate, precision, RoundingMode.HALF_UP);
        }
        return srcDecimal.multiply(exChangeRate).setScale(precision, 4);
    }
}

