/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.business.utils.MetaHelper;
import kd.scmc.ism.business.utils.SelectParams;
import kd.scmc.ism.common.selectstrategy.IColsSelectStrategy;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.formplugin.ext.ConditionHiddenPlugin;
import kd.scmc.ism.lang.FormLang;

public class PageShowHelper {
    private static final String EntityNumber_LookUpTracker = "botp_lookuptracker";
    private static final String CustParamKey_LookUpType = "lookuptype";
    private static final String CustParamKey_LinkNodes = "linknodes";
    private static final String LookUpType_Down = "lookdown";

    private PageShowHelper() {
    }

    public static void showSelectColsPage(IFormView view, String entityName, IColsSelectStrategy strategy, String pagename, CloseCallBack callBack) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        MetaHelper metaHelper = new MetaHelper(strategy, mainEntityType);
        String colsJosnTree = metaHelper.buildTree2JSON();
        SelectParams params = new SelectParams();
        params.setJsonTree(colsJosnTree);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mscommon_colstree_select");
        if (pagename != null) {
            showParameter.setCaption(pagename);
        } else {
            showParameter.setCaption(FormLang.plsSelectField());
        }
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    @Deprecated
    public static void showCombSelectPage(IFormView view, ComboProp comboProp, CloseCallBack closeCallBack) {
        List comboItems = comboProp.getComboItems();
        ArrayList combitems = new ArrayList(comboItems.size());
        for (ValueMapItem item : comboItems) {
            HashMap<String, String> values = new HashMap<String, String>(3);
            values.put("ImageKey", item.getImageKey());
            values.put("Name", item.getName().getLocaleValue());
            values.put("Value", item.getValue());
            combitems.add(values);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_comboitemsselect");
        showParameter.getCustomParams().put("comboProp", combitems);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void showF7ValueSelectPage(IFormView view, BasedataProp basedataProp, CloseCallBack closeCallBack) {
        ListShowParameter basedataF7Param = ShowFormHelper.createShowListForm((String)basedataProp.getBaseEntityId(), (boolean)false);
        basedataF7Param.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)basedataF7Param);
    }

    public static void showF7ValueMulSelectPage(IFormView view, BasedataProp basedataProp, Object[] selectRowIds, CloseCallBack closeCallBack) {
        ListShowParameter basedataF7Param = ShowFormHelper.createShowListForm((String)basedataProp.getBaseEntityId(), (boolean)false);
        basedataF7Param.setCloseCallBack(closeCallBack);
        basedataF7Param.setMultiSelect(true);
        if (selectRowIds != null) {
            basedataF7Param.setSelectedRows(selectRowIds);
        }
        view.showForm((FormShowParameter)basedataF7Param);
    }

    @Deprecated
    public static void showCommonConstsInputPage(IFormView view, IDataEntityProperty prop, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        String constsType = null;
        String caption = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5185\u5bb9", (String)"PlsInputContent", (String)"scmc-ism-form", (Object[])new Object[0]);
        if (prop instanceof DateProp) {
            constsType = "date";
            caption = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PlsInputDate", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else if (prop instanceof DateTimeProp) {
            constsType = "datetime";
            caption = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PlsInputDate", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else if (prop instanceof DecimalProp) {
            constsType = "decimal";
            caption = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u5b57", (String)"PlsInputNumber", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else if (prop instanceof BooleanProp) {
            constsType = "checkbox";
            caption = ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5185\u5bb9", (String)"PlsSelectContent", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else if (prop instanceof TextProp) {
            constsType = "text";
            caption = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6587\u672c", (String)"PlsInputText", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else {
            return;
        }
        showParameter.setFormId("ism_inputconsts");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getCustomParams().put("type", constsType);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(caption);
        view.showForm(showParameter);
    }

    public static void showNewBillFieldPage(IFormView view, String targetBillType, CloseCallBack closeCallBack) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("ism_billfieldresetrule");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("680px");
        baseShowParameter.getOpenStyle().setInlineStyleCss(css);
        baseShowParameter.setCustomParam("billtype", (Object)targetBillType);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    public static void showBillEdit(IFormView view, DynamicObject obj) {
        PageShowHelper.showBillEdit(view, obj.getDataEntityType().getName(), obj.getPkValue());
    }

    public static void showBillEdit(IFormView view, DynamicObject billObj, Object pkValue) {
        if (pkValue == null || pkValue.equals(0L)) {
            return;
        }
        PageShowHelper.showBillEdit(view, billObj.getString("number"), pkValue);
    }

    public static void showBillEdit(IFormView view, String entityName, Object pkValue) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId(pkValue);
        showParameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showBaseEdit(IFormView view, String entityName, Object logId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(entityName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId(logId);
        view.showForm((FormShowParameter)showParameter);
    }

    public static void showLookDownPage(IFormView view, String caption, List<BFRowLinkDownNode> loadLinkDownNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(EntityNumber_LookUpTracker);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String nodesJson = SerializationUtils.serializeToBase64(loadLinkDownNodes);
        showParameter.getCustomParams().put(CustParamKey_LinkNodes, nodesJson);
        showParameter.getCustomParams().put(CustParamKey_LookUpType, LookUpType_Down);
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        view.showForm(showParameter);
    }

    public static void showOperResult(IFormView view, Map<String, Object> failInfo) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ism_settleinfo");
        showParameter.getCustomParams().put("failInfo", SerializationUtils.toJsonString(failInfo));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void showOperResult(IFormView view, Map<String, Object> failInfo, String caption) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ism_settleinfo");
        showParameter.getCustomParams().put("failInfo", SerializationUtils.toJsonString(failInfo));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        view.showForm(showParameter);
    }

    public static void showVBillInfo(IFormView view, List<Map<String, Object>> vbillinfo) {
        PageShowHelper.showVBillInfo(view, vbillinfo, null);
    }

    public static void showVBillInfo(IFormView view, List<Map<String, Object>> vbillinfo, Map<String, String> custParam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ism_virtualbillinfo");
        showParameter.getCustomParams().put("vbillinfo", SerializationUtils.toJsonString(vbillinfo));
        if (CommonUtils.mapIsNotEmpty(custParam)) {
            showParameter.getCustomParams().putAll(custParam);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static ListShowParameter getBaseDataListParam(String bdEntity, QFilter dataQFilter) {
        ListShowParameter params = new ListShowParameter();
        params.setBillFormId(bdEntity);
        if (dataQFilter != null) {
            ListFilterParameter filterParam = new ListFilterParameter();
            filterParam.setFilter(dataQFilter);
            params.setListFilterParameter(filterParam);
        }
        params.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        params.setFormId("bos_list");
        return params;
    }

    public static FormShowParameter getBotpRuleParam(String sourceBill, String targetBill, Object ruleId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_convertrule");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("SourceBill", (Object)sourceBill);
        showParameter.setCustomParam("TargetBill", (Object)targetBill);
        showParameter.setCustomParam("ruleId", ruleId);
        showParameter.getCustomParams().put("checkRightAppId", "bpm");
        showParameter.setPageId(ruleId + "_" + sourceBill + "_" + targetBill);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setAppId("ism");
        showParameter.addCustPlugin("kd.scmc.ism.formplugin.ext.ConvertRuleLockEdit");
        return showParameter;
    }

    public static FormShowParameter getConditionParam(CloseCallBack cb) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.setCloseCallBack(cb);
        showParameter.addCustPlugin(ConditionHiddenPlugin.class.getName());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }
}

