/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SettleBillQueryHelper {
    public static List<Map<String, Object>> getAllSettleBillBySingle(Object id) {
        return SettleBillQueryHelper.getAllSettleBillBySingle(id, null);
    }

    public static List<Map<String, Object>> getAllSettleBillBySingle(Object id, Set<Object> entryids) {
        if (id == null || id.toString().trim().length() == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        QFilter filter = new QFilter("entryentity.settlebillid", "=", id);
        filter.and("createstatus", "=", (Object)"A");
        DynamicObject billsettlelog = QueryServiceHelper.queryOne((String)"ism_settlelog", (String)"id,entryentity.settlebillid,entryentity.settlebilltype", (QFilter[])filter.toArray());
        if (billsettlelog == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        Object settleLogid = billsettlelog.get("id");
        DynamicObject settlelog = BusinessDataServiceHelper.loadSingle((Object)settleLogid, (String)"ism_settlelog");
        Boolean isEntry = Boolean.FALSE;
        HashSet<Object> srcEntryids = new HashSet<Object>();
        if (entryids != null && entryids.size() > 0) {
            isEntry = Boolean.TRUE;
            String settlebilltype = billsettlelog.getString("entryentity.settlebilltype");
            DynamicObjectCollection srcbillentries = QueryServiceHelper.query((String)settlebilltype, (String)"billentry.id,billentry.srcbillentryid", (QFilter[])new QFilter("billentry.id", "in", entryids).toArray());
            for (Iterator srbillentry : srcbillentries) {
                srcEntryids.add(srbillentry.get("billentry.srcbillentryid"));
            }
        }
        HashMap billTypeToBillmap = new HashMap();
        HashMap<Object, Object> settleBillToPathmap = new HashMap<Object, Object>();
        DynamicObjectCollection logs = settlelog.getDynamicObjectCollection("entryentity");
        for (Object log : logs) {
            settleBillToPathmap.put(log.get("settlebillid"), log.get("settlepath"));
            String string = log.getDynamicObject("settlebilltype").getString("number");
            Object billid = log.get("settlebillid");
            switch (string) {
                case "im_saloutbill": 
                case "im_purinbill": 
                case "im_transinbill": 
                case "im_transoutbill": {
                    if (!billTypeToBillmap.containsKey(string)) {
                        ArrayList ids = new ArrayList();
                        billTypeToBillmap.put(string, ids);
                    }
                    ((List)billTypeToBillmap.get(string)).add(billid);
                    break;
                }
            }
        }
        ArrayList bills = new ArrayList();
        for (Map.Entry entry : billTypeToBillmap.entrySet()) {
            String billType = (String)entry.getKey();
            List ids = (List)entry.getValue();
            QFilter billFilter = new QFilter("id", "in", (Object)ids);
            String selectedField = "id,'" + billType + "' as billtype";
            if (isEntry.booleanValue()) {
                selectedField = selectedField + ",billentry.id";
                billFilter.and("billentry.srcbillentryid", "in", srcEntryids);
            }
            bills.addAll(QueryServiceHelper.query((String)billType, (String)selectedField, (QFilter[])billFilter.toArray()));
        }
        if (bills.size() == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(bills.size());
        for (DynamicObject bill : bills) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object billid = bill.get("id");
            map.put("settlebillid", billid);
            map.put("settlebilltype", bill.get("billtype"));
            map.put("settlepath", settleBillToPathmap.get(billid));
            if (isEntry.booleanValue()) {
                map.put("settlebillentryid", bill.get("billentry.id"));
            }
            result.add(map);
        }
        return result;
    }
}

