/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.helper.ResultInfoHelper;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.ModelLang;

public class SettleLogHelper {
    protected static final Log log = LogFactory.getLog(SettleLogHelper.class);
    private static final String SETTLELOG_FIELDS = "id, createstatus, sourceid, sourcenum, sourcetype, sourcenum, biztraceno,entryentity.settlebillid, entryentity.settlebilltype, entryentity.settlebillno,entryentity.groupkey, entryentity.bizflow, entryentity.iscreat, entryentity.billstatus, entryentity.failcause";

    public static DynamicObject[] getLogInfoBySrcIds(Collection<Long> srcBillIds) {
        return SettleLogHelper.getSimpleLogInfo(new QFilter("sourceid", "in", srcBillIds));
    }

    public static DynamicObject[] getSimpleLogInfo(QFilter filter) {
        return BusinessDataServiceHelper.load((String)"ism_settlelog", (String)SETTLELOG_FIELDS, (QFilter[])filter.toArray());
    }

    @Deprecated
    public static Map<Long, DynamicObject> getSuccessLogByBillIds(List<Long> billIds) {
        DynamicObject[] settleLogs = SettleLogHelper.getSimpleLogInfo(new QFilter("sourceid", "in", billIds));
        HashMap<Long, DynamicObject> logs = new HashMap<Long, DynamicObject>(settleLogs.length);
        for (DynamicObject settleLog : settleLogs) {
            long sourceBillId = settleLog.getLong("sourceid");
            logs.put(sourceBillId, settleLog);
        }
        return logs;
    }

    public static Map<String, Set<Object>> getGenerateBillsFromLog(DynamicObject log) {
        return SettleLogHelper.getGenerateBillsFromLogs(Collections.singletonList(log));
    }

    public static Map<String, Set<Object>> getGenerateBillsFromLogs(Collection<DynamicObject> logs) {
        HashMap<String, Set<Object>> settleBills = new HashMap<String, Set<Object>>(16);
        for (DynamicObject obj : logs) {
            DynamicObjectCollection settleBillInfos = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject settleBillInfo : settleBillInfos) {
                Long id = settleBillInfo.getLong("settlebillid");
                if (id == null || id.equals(0L)) continue;
                String billnumber = settleBillInfo.getDynamicObject("settlebilltype").getString("number");
                HashSet<Long> billIds = (HashSet<Long>)settleBills.get(billnumber);
                if (billIds == null) {
                    billIds = new HashSet<Long>(settleBillInfos.size());
                    settleBills.put(billnumber, billIds);
                }
                billIds.add(id);
            }
        }
        return settleBills;
    }

    public static Map<String, Object> parseLogInfo(Collection<SettleLogHandler> allLogs) {
        boolean isSuccess = true;
        StringBuilder failreasons = new StringBuilder();
        for (SettleLogHandler settleLogHandler : allLogs) {
            DynamicObject log = settleLogHandler.getDataLog();
            String sourceBillNo = log.getString("sourcenum");
            String status = log.getString("createstatus");
            DynamicObjectCollection logDetail = log.getDynamicObjectCollection("entryentity");
            if (!"A".equals(status)) {
                String failReason = log.getString("billfailcause");
                failreasons.append(ModelLang.billGenerateFail(sourceBillNo, failReason));
                isSuccess = false;
                continue;
            }
            if (!CommonUtils.collectionIsEmpty(logDetail)) continue;
            failreasons.append(ModelLang.noSettleBillGenerate());
            isSuccess = false;
        }
        if (isSuccess) {
            return ResultInfoHelper.buildSuccessResult();
        }
        return ResultInfoHelper.buildFailResult(failreasons.toString());
    }
}

