/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.algorithm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ism.business.helper.CurrencyHelper;
import kd.scmc.ism.business.helper.algorithm.AbstractAlgorithm;
import kd.scmc.ism.common.consts.enums.imenums.DiscountTypeEnum;
import kd.scmc.ism.common.consts.imconst.BigDecimalConstants;

public abstract class AbstractTaxAlgorithm
extends AbstractAlgorithm {
    private static final Long DEFAULT_INVOICE_BIZ = 1533341968170710016L;
    private static final Long PROFORMA_INVOICE_BIZ = 1571047306646894592L;
    protected static Log log = LogFactory.getLog(AbstractTaxAlgorithm.class);
    protected int amountPrecision = 2;
    protected int curAmountPrecision = 2;
    protected int pricePrecision = 10;
    protected int curPricePrecision = 10;

    protected void initPrecision() {
        DynamicObject curCurrency;
        DynamicObject currency = (DynamicObject)this.getValue("settlecurrency");
        if (currency != null) {
            this.amountPrecision = currency.getInt("amtprecision");
        }
        if ((curCurrency = (DynamicObject)this.getValue("currency")) != null) {
            this.curAmountPrecision = curCurrency.getInt("amtprecision");
        }
    }

    protected void calByQty(int i) {
        if (this.hasTax()) {
            this.calPrice(i);
        } else {
            this.calPriceAndTax(i);
        }
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    private void calPrice(int i) {
        BigDecimal taxPrice = this.getNullToZero("priceandtax", i);
        BigDecimal taxRate = this.getNullToZero("taxrate", i);
        BigDecimal price = BigDecimalConstants.ZERO;
        if (taxPrice != null) {
            BigDecimal zero = BigDecimalConstants.ZERO;
            BigDecimal one = BigDecimalConstants.ONE;
            BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
            taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
            price = taxPrice.divide(one.add(taxRate), this.pricePrecision, 4);
        }
        this.setValue("price", price, i);
    }

    private void calPriceAndTax(int i) {
        BigDecimal price = this.getNullToZero("price", i);
        BigDecimal taxRate = this.getNullToZero("taxrate", i);
        BigDecimal taxPrice = BigDecimalConstants.ZERO;
        BigDecimal one = BigDecimalConstants.ONE;
        BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
        taxRate = taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
        taxPrice = price.multiply(one.add(taxRate));
        taxPrice = taxPrice.setScale(this.pricePrecision, 4);
        this.setValue("priceandtax", taxPrice, i);
    }

    public void calDiscountAmount(int i) {
        DiscountTypeEnum discountTypeEnum;
        BigDecimal price = this.getNullToZero("priceandtax", i);
        BigDecimal qty = this.getNullToZero("qty", i);
        BigDecimal discountRate = this.getNullToZero("discountrate", i);
        String discountType = (String)this.getValue("discounttype", i);
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)discountType) && (discountTypeEnum = DiscountTypeEnum.get(discountType)) != null) {
            switch (discountTypeEnum) {
                case DISRATE: {
                    discountAmount = price.multiply(qty).multiply(discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4)).setScale(this.amountPrecision, 4);
                    break;
                }
                case UNITDIS: 
                case DISAMT: {
                    if (this.hasTax()) {
                        discountAmount = qty.multiply(discountRate).setScale(this.amountPrecision, 4);
                        break;
                    }
                    BigDecimal taxRate = this.getNullToZero("taxrate", i);
                    taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4);
                    discountAmount = qty.multiply(discountRate).multiply(BigDecimal.ONE.add(taxRate)).setScale(this.amountPrecision, 4);
                    break;
                }
                case NULL: {
                    break;
                }
            }
        }
        this.setValue("discountamount", discountAmount, i);
    }

    private void calActualPrice(int i) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", i);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal price = this.getNullToZero("price", i);
            this.setValue("actualprice", price, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            if (BigDecimal.ZERO.compareTo(amount) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                this.setValue("actualprice", BigDecimal.ZERO, i);
            } else {
                BigDecimal price = amount.divide(qty, this.pricePrecision, 4);
                this.setValue("actualprice", price, i);
            }
        }
    }

    private void calActualTaxPrice(int i) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", i);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal taxPrice = this.getNullToZero("priceandtax", i);
            this.setValue("actualtaxprice", taxPrice, i);
        } else {
            BigDecimal amountAndTax = this.getNullToZero("amountandtax", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            if (BigDecimal.ZERO.compareTo(amountAndTax) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                this.setValue("actualtaxprice", BigDecimal.ZERO, i);
            } else {
                BigDecimal taxPrice = amountAndTax.divide(qty, this.pricePrecision, 4);
                this.setValue("actualtaxprice", taxPrice, i);
            }
        }
    }

    private void calAmountAndTax(int i) {
        if (this.hasTax()) {
            BigDecimal priceAndTax = this.getNullToZero("priceandtax", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal taxAmount = BigDecimal.ZERO;
            BigDecimal discountAmount = this.getNullToZero("discountamount", i);
            BigDecimal discountRate = this.getNullToZero("discountrate", i);
            String discountType = (String)this.getValue("discounttype", i);
            taxAmount = DiscountTypeEnum.DISRATE.getValue().equals(discountType) && discountRate.compareTo(BigDecimalConstants.ONEHUNDRED) == 0 ? qty.multiply(priceAndTax).setScale(this.amountPrecision, 4).subtract(discountAmount) : qty.multiply(priceAndTax).subtract(discountAmount).setScale(this.amountPrecision, 4);
            AbstractTaxAlgorithm.setTaxAmountErrorTip(taxAmount);
            this.setValue("amountandtax", taxAmount, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal tax = this.getNullToZero("taxamount", i);
            BigDecimal taxAmount = amount.add(tax);
            AbstractTaxAlgorithm.setTaxAmountErrorTip(taxAmount);
            this.setValue("amountandtax", taxAmount, i);
        }
    }

    public static void setTaxAmountErrorTip(BigDecimal taxAmount) {
        if (taxAmount.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u8d85\u8fc7\u7cfb\u7edf\u9884\u5236\u6700\u5927\u503c\u201c9999999999999\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractTaxAlgorithm_0", (String)"scmc-ism-form", (Object[])new Object[0]));
        }
    }

    private void calCurAmountAndTax(int i) {
        if (this.hasTax()) {
            String quotation = (String)this.getValue("quotation");
            BigDecimal taxAmount = this.getNullToZero("amountandtax", i);
            BigDecimal exchangerate = this.getNullToZero("exchangerate");
            BigDecimal localTaxAmount = CurrencyHelper.exrateExchange(taxAmount, quotation, exchangerate, this.curAmountPrecision);
            this.setValue("curamountandtax", localTaxAmount, i);
        } else {
            BigDecimal localAmount = this.getNullToZero("curamount", i);
            BigDecimal localTax = this.getNullToZero("curtaxamount", i);
            this.setValue("curamountandtax", localAmount.add(localTax), i);
        }
    }

    private void calTaxAmount(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", i);
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (taxAmount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = taxAmount.multiply(taxRate).divide(taxRate.add(BigDecimalConstants.ONE), this.amountPrecision, 4);
            }
            this.setValue("taxamount", tax, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (amount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = amount.multiply(taxRate).setScale(this.amountPrecision, 4);
            }
            this.setValue("taxamount", tax, i);
        }
    }

    private void calCurTaxAmount(int i) {
        String quotation = (String)this.getValue("quotation");
        BigDecimal tax = this.getNullToZero("taxamount", i);
        BigDecimal exchangerate = this.getNullToZero("exchangerate");
        BigDecimal localTax = CurrencyHelper.exrateExchange(tax, quotation, exchangerate, this.curAmountPrecision);
        this.setValue("curtaxamount", localTax, i);
    }

    private void calAmount(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", i);
            BigDecimal tax = this.getNullToZero("taxamount", i);
            BigDecimal amount = taxAmount.subtract(tax);
            this.setValue("amount", amount, i);
        } else {
            BigDecimal price = this.getNullToZero("price", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal discountRate = this.getNullToZero("discountrate", i);
            String discountType = (String)this.getValue("discounttype", i);
            if (StringUtils.isNotEmpty((CharSequence)discountType)) {
                DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get(discountType);
                switch (discountTypeEnum) {
                    case DISRATE: {
                        amount = price.multiply(qty).multiply(BigDecimal.ONE.subtract(discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4)));
                        break;
                    }
                    case UNITDIS: 
                    case DISAMT: {
                        amount = qty.multiply(price.subtract(discountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case NULL: {
                        amount = qty.multiply(price).setScale(this.amountPrecision, 4);
                        break;
                    }
                }
            } else {
                amount = qty.multiply(price).setScale(this.amountPrecision, 4);
            }
            this.setValue("amount", amount, i);
        }
    }

    private void calCurAmount(int i) {
        if (this.hasTax()) {
            BigDecimal LocalTaxAmount = this.getNullToZero("curamountandtax", i);
            BigDecimal LocalTax = this.getNullToZero("curtaxamount", i);
            this.setValue("curamount", LocalTaxAmount.subtract(LocalTax), i);
        } else {
            String quotation = (String)this.getValue("quotation");
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal exchangerate = this.getNullToZero("exchangerate");
            BigDecimal localTaxAmount = CurrencyHelper.exrateExchange(amount, quotation, exchangerate, this.curAmountPrecision);
            this.setValue("curamount", localTaxAmount, i);
        }
    }

    protected void calEntryAmountFileds(int i) {
        if (this.hasTax()) {
            this.calAmountAndTax(i);
            this.calTaxAmount(i);
            this.calAmount(i);
        } else {
            this.calAmount(i);
            this.calTaxAmount(i);
            this.calAmountAndTax(i);
        }
    }

    protected void calEntryCurFileds(int i) {
        if (this.hasTax()) {
            this.calCurAmountAndTax(i);
            this.calCurTaxAmount(i);
            this.calCurAmount(i);
        } else {
            this.calCurAmount(i);
            this.calCurTaxAmount(i);
            this.calCurAmountAndTax(i);
        }
    }

    protected void handleDeductibleRateBotp(DynamicObject bill) {
        if (!this.isPurInBillType(bill)) {
            return;
        }
        boolean isFarmBill = this.isFarmBill(bill);
        DynamicObject invoiceBiz = bill.getDynamicObject("invoicebiztype");
        Long invoiceBizId = invoiceBiz != null ? invoiceBiz.getLong("id") : 0L;
        int i = 0;
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            if (isFarmBill) {
                DynamicObject material;
                Object deductibleRate;
                DynamicObject materialInfo = entry.getDynamicObject("material");
                if (materialInfo == null) continue;
                BigDecimal entryDeductibleRate = entry.getBigDecimal("deductiblerate");
                if ((null == entryDeductibleRate || entryDeductibleRate.compareTo(BigDecimal.ZERO) == 0) && null != (deductibleRate = (material = materialInfo.getDynamicObject("masterid")).get("deductiblerate"))) {
                    entry.set("deductiblerate", deductibleRate);
                }
            } else if (invoiceBiz != null) {
                Object taxPayerType = entry.get("taxpayertype");
                if ("1".equals(taxPayerType) && (DEFAULT_INVOICE_BIZ.equals(invoiceBizId) || PROFORMA_INVOICE_BIZ.equals(invoiceBizId))) {
                    Object taxRate = entry.get("taxrate");
                    entry.set("deductiblerate", taxRate);
                } else {
                    entry.set("deductiblerate", (Object)BigDecimal.ZERO);
                }
            }
            this.calFarmieldsByCurAmount(i);
            ++i;
        }
    }

    private void calFarmieldsByCurAmount(int i) {
        String quotation;
        BigDecimal deductibleAmt;
        BigDecimal curAmount = this.getNullToZero("curamount", i);
        BigDecimal amount = this.getNullToZero("amount", i);
        BigDecimal deductibleRate = this.getNullToZero("deductiblerate", i);
        deductibleRate = deductibleRate.divide(BigDecimalConstants.ONEHUNDRED, deductibleRate.scale() + 2, 4);
        BigDecimal curAmountAndTax = this.getNullToZero("curamountandtax", i);
        BigDecimal amountAndTax = this.getNullToZero("amountandtax", i);
        if (this.hasTax()) {
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
            deductibleAmt = amountAndTax.multiply(deductibleRate).divide(taxRate.add(BigDecimalConstants.ONE), this.amountPrecision, 4);
        } else {
            deductibleAmt = amount.multiply(deductibleRate).setScale(this.amountPrecision, 4);
        }
        BigDecimal exchangeRate = (BigDecimal)this.getValue("exchangerate");
        if (null == exchangeRate) {
            exchangeRate = BigDecimal.ONE;
        }
        if ("0".equals(quotation = (String)this.getValue("quotation"))) {
            deductibleAmt = deductibleAmt.multiply(exchangeRate).setScale(this.curAmountPrecision, RoundingMode.HALF_UP);
        } else if ("1".equals(quotation) && BigDecimal.ZERO.compareTo(exchangeRate) != 0) {
            deductibleAmt = deductibleAmt.divide(exchangeRate, this.curAmountPrecision, RoundingMode.HALF_UP);
        }
        this.setValue("curdeductibleamt", deductibleAmt, i);
        BigDecimal interCostAmt = curAmountAndTax.subtract(deductibleAmt).setScale(this.curAmountPrecision, 4);
        Object taxPayerType = this.getValue("taxpayertype", i);
        if (StringUtils.isBlank((Object)taxPayerType)) {
            interCostAmt = BigDecimal.ZERO;
        }
        this.setValue("intercostamt", interCostAmt, i);
    }

    private boolean isPurInBillType(DynamicObject bill) {
        String entityName = bill.getDynamicObjectType().getName();
        return "im_purinbill".equals(entityName);
    }

    private boolean isFarmBill(DynamicObject bill) {
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (billType == null) {
            return false;
        }
        String billTypeNum = billType.getString("number");
        return "im_PurInBill_FARM_BT_S".equals(billTypeNum);
    }

    public boolean hasTax() {
        boolean isTax = (Boolean)this.getValue("istax");
        return isTax;
    }
}

