/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.filter;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.helper.BizConfigHelper;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;

public class CommonF7SelectFilterHelper {
    private CommonF7SelectFilterHelper() {
    }

    public static QFilter getSettleJudgeBillTypeFilter() {
        return new QFilter("id", "in", BizConfigHelper.getEnableSettleJudgeBills());
    }

    public static QFilter getBizDirectJudgeBillTypeFilter() {
        return new QFilter("id", "in", BizConfigHelper.getEnableBizDirectBills());
    }

    public static QFilter getBillFieldRstBillTypeFilter() {
        Map judgements = BusinessDataServiceHelper.loadFromCache((String)"ism_billfieldresetrule", (QFilter[])CommonFilterHelper.getAllFilters());
        HashSet<Object> billIds = new HashSet<Object>(judgements.size());
        for (DynamicObject judgement : judgements.values()) {
            DynamicObject bill = judgement.getDynamicObject("targetbill");
            if (bill == null) continue;
            billIds.add(bill.getPkValue());
        }
        return new QFilter("id", "in", billIds);
    }

    public static QFilter getSettleRelationOrgFilter(long settleRelationId) {
        DynamicObjectCollection details = QueryServiceHelper.query((String)"ism_settlerelations", (String)"settlerelationdetail.supplier,settlerelationdetail.demand", (QFilter[])new QFilter("id", "=", (Object)settleRelationId).toArray());
        HashSet<Long> ids = new HashSet<Long>(details.size() * 2);
        for (DynamicObject detail : details) {
            ids.add(detail.getLong("settlerelationdetail.supplier"));
            ids.add(detail.getLong("settlerelationdetail.demand"));
        }
        return new QFilter("id", "in", ids);
    }

    public static QFilter getPermissionOrg(String formId) {
        return new QFilter("id", "in", BizConfigHelper.getPermissionOrg(formId));
    }
}

