/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.filter;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;

public class CommonFilterHelper {
    public static QFilter getEmptyFilter() {
        return new QFilter("1", "!=", (Object)1);
    }

    public static QFilter getAllFilter() {
        return new QFilter("1", "=", (Object)1);
    }

    public static QFilter[] getAllFilters() {
        return CommonFilterHelper.getAllFilter().toArray();
    }

    public static List<QFilter> getFromToFilters(String queryField, String from, String to) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        if (StringUtils.isNotEmpty((CharSequence)from)) {
            if (!from.contains(" ")) {
                filters.add(new QFilter(queryField, ">=", (Object)from));
            } else {
                filters.add(new QFilter(queryField, "in", (Object)from.split(" ")));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)to)) {
            filters.add(new QFilter(queryField, "<=", (Object)to));
        }
        return filters;
    }

    public static QFilter getFromToFilter(String queryField, String from, String to) {
        QFilter filter = null;
        if (StringUtils.isNotEmpty((CharSequence)from)) {
            filter = !from.contains(" ") ? CommonFilterHelper.combine(filter, queryField, ">=", from) : CommonFilterHelper.combine(filter, queryField, "in", from.split(" "));
        }
        if (StringUtils.isNotEmpty((CharSequence)to)) {
            filter = CommonFilterHelper.combine(filter, queryField, "<=", to);
        }
        return filter;
    }

    private static QFilter combine(QFilter f1, String property, String cp, Object value) {
        return CommonFilterHelper.combine(f1, new QFilter(property, cp, value));
    }

    private static QFilter combine(QFilter f1, QFilter f2) {
        if (f1 == null) {
            return f2;
        }
        return f1.and(f2);
    }
}

