/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.inputconsts;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.ism.common.model.args.InputConstsResult;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractInputConstsHandler<T extends IDataEntityProperty> {
    public abstract String getPrefixKey();

    public FormShowParameter getFormShowParam(IFormPlugin formPlugin, T prop, String srcValue, String closedCallBackId) {
        FormShowParameter formShowParam = this.buildFormShowParam(prop, srcValue);
        if (formShowParam == null) {
            return null;
        }
        StringBuilder actionId = new StringBuilder();
        actionId.append(this.getPrefixKey());
        actionId.append('_');
        actionId.append(closedCallBackId);
        formShowParam.setCloseCallBack(new CloseCallBack(formPlugin, actionId.toString()));
        formShowParam.getOpenStyle().setShowType(ShowType.Modal);
        return formShowParam;
    }

    protected abstract FormShowParameter buildFormShowParam(T var1, String var2);

    public InputConstsResult getResultFromCallBack(ClosedCallBackEvent e) {
        if (!e.getActionId().startsWith(this.getPrefixKey())) {
            return null;
        }
        InputConstsResult result = this.buildResultInfo(e);
        if (result != null) {
            result.setCloseCallBackId(StringUtils.substring((String)e.getActionId(), (int)(this.getPrefixKey().length() + 1)));
        }
        return result;
    }

    protected abstract InputConstsResult buildResultInfo(ClosedCallBackEvent var1);
}

