/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.inputconsts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.scmc.ism.business.helper.inputconsts.AbstractInputConstsHandler;
import kd.scmc.ism.common.model.args.InputConstsResult;
import org.apache.commons.lang.StringUtils;

public class InputComboConstsHandler
extends AbstractInputConstsHandler<ComboProp> {
    public static final String CALL_BACK_PREFIX = "selectCombCB";

    @Override
    public String getPrefixKey() {
        return CALL_BACK_PREFIX;
    }

    @Override
    protected FormShowParameter buildFormShowParam(ComboProp prop, String srcValue) {
        List comboItems = prop.getComboItems();
        ArrayList combitems = new ArrayList(comboItems.size());
        for (ValueMapItem item : comboItems) {
            HashMap<String, String> values = new HashMap<String, String>(3);
            values.put("ImageKey", item.getImageKey());
            values.put("Name", item.getName().getLocaleValue());
            values.put("Value", item.getValue());
            combitems.add(values);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_comboitemsselect");
        showParameter.getCustomParams().put("comboProp", combitems);
        return showParameter;
    }

    @Override
    protected InputConstsResult buildResultInfo(ClosedCallBackEvent e) {
        String selectedComob = (String)e.getReturnData();
        if (StringUtils.isNotEmpty((String)selectedComob)) {
            Map valByConditions = (Map)SerializationUtils.fromJsonString((String)selectedComob, Map.class);
            return new InputConstsResult(valByConditions.get("exprTran"), valByConditions.get("expression"));
        }
        return null;
    }
}

