/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.inputconsts;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.scmc.ism.business.helper.inputconsts.AbstractInputConstsHandler;
import kd.scmc.ism.common.model.args.InputConstsResult;

public class InputCommonConstsHandler
extends AbstractInputConstsHandler<IDataEntityProperty> {
    public static final String CALL_BACK_PREFIX = "selectConstsCB";

    @Override
    public String getPrefixKey() {
        return CALL_BACK_PREFIX;
    }

    @Override
    protected FormShowParameter buildFormShowParam(IDataEntityProperty prop, String srcValue) {
        FormShowParameter showParameter = new FormShowParameter();
        String constsType = null;
        String caption = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5185\u5bb9", (String)"PlsInputContent", (String)"scmc-ism-form", (Object[])new Object[0]);
        if (prop instanceof DateProp) {
            constsType = "date";
            caption = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PlsInputDate", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else if (prop instanceof DateTimeProp) {
            constsType = "datetime";
            caption = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PlsInputDate", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else if (prop instanceof DecimalProp) {
            constsType = "decimal";
            caption = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u5b57", (String)"PlsInputNumber", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else if (prop instanceof BooleanProp) {
            constsType = "checkbox";
            caption = ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u5185\u5bb9", (String)"PlsSelectContent", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else if (prop instanceof TextProp) {
            constsType = "text";
            caption = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6587\u672c", (String)"PlsInputText", (String)"scmc-ism-form", (Object[])new Object[0]);
        } else {
            return null;
        }
        showParameter.setFormId("ism_inputconsts");
        showParameter.getCustomParams().put("type", constsType);
        showParameter.getCustomParams().put("srcvalue", srcValue);
        showParameter.setCaption(caption);
        return showParameter;
    }

    @Override
    protected InputConstsResult buildResultInfo(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof Date) {
            Date date = (Date)returnData;
            String formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            return new InputConstsResult(formatTime, date.getTime());
        }
        if (returnData instanceof Boolean) {
            Boolean bool = (Boolean)returnData;
            String text = bool != false ? ResManager.loadKDString((String)"\u662f", (String)"Yes", (String)"scmc-ism-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"No", (String)"scmc-ism-form", (Object[])new Object[0]);
            return new InputConstsResult(text, bool);
        }
        if (returnData instanceof String) {
            return new InputConstsResult(returnData, returnData);
        }
        if (returnData instanceof BigDecimal) {
            String decimalstr = ((BigDecimal)returnData).toPlainString();
            return new InputConstsResult(decimalstr, decimalstr);
        }
        return null;
    }
}

