/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.recalprice.arap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.ism.business.helper.recalprice.arap.AbstractPriceCalculator;
import kd.scmc.ism.business.helper.recalprice.arap.PriceLocalCalculator;
import kd.scmc.ism.business.helper.recalprice.arap.TaxUnitPriceCalculator;
import kd.scmc.ism.business.helper.recalprice.arap.UnitPriceCalculator;
import kd.scmc.ism.lang.CommonLang;

public class ArBillAmountReCalHelper {
    public static void arBillAmountReCal(DynamicObject finArBill) {
        DynamicObject org = finArBill.getDynamicObject("org");
        DynamicObject recorg = finArBill.getDynamicObject("recorg");
        if (!ObjectUtils.isEmpty((Object)recorg) && !recorg.getBoolean("fisbankroll")) {
            finArBill.set("recorg", null);
        }
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        DynamicObject init = ArBillAmountReCalHelper.getInitObj(org, "ar_init", finArBill);
        if (init == null || init.getDate("startdate") == null) {
            ErrorCode ORGNAME_NOT_SET = new ErrorCode("ARAPORGNAME_NOT_FINISHINIT", CommonLang.orgNotInitCanNotCreateBill());
            throw new KDBizException(ORGNAME_NOT_SET, new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
        DynamicObject bascurrency = init.getDynamicObject("standardcurrency");
        finArBill.set("basecurrency", (Object)bascurrency);
        DynamicObject exeatetable = init.getDynamicObject("exratetable");
        finArBill.set("exratetable", (Object)exeatetable);
        finArBill.set("exratedate", (Object)new Date());
        DynamicObject currency = finArBill.getDynamicObject("currency");
        if (bascurrency != null && currency != null && exeatetable != null) {
            BigDecimal exchangeRate = ArBillAmountReCalHelper.getExchangeRate(exeatetable.getLong("id"), currency.getLong("id"), bascurrency.getLong("id"), new Date());
            finArBill.set("exchangerate", (Object)exchangeRate);
        }
        DynamicObject bascur = finArBill.getDynamicObject("basecurrency");
        int baseprecision = bascur.getInt("amtprecision");
        finArBill.set("duedate", (Object)new Date());
        BigDecimal recAmount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal reclocalamt = BigDecimal.ZERO;
        BigDecimal unsettlelocalamt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unVerifyAmount = BigDecimal.ZERO;
        BigDecimal unSettleAmount = BigDecimal.ZERO;
        DynamicObjectCollection entries = finArBill.getDynamicObjectCollection("entry");
        boolean includeTax = finArBill.getBoolean("isincludetax");
        BigDecimal exchangeRate = finArBill.getBigDecimal("exchangerate");
        for (DynamicObject entry : entries) {
            PriceLocalCalculator localCalculator = null;
            AbstractPriceCalculator calculator = null;
            BigDecimal qty = entry.getBigDecimal("e_quantity");
            BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
            String discountMode = entry.getString("e_discountmode");
            BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
            if (includeTax) {
                BigDecimal taxUnitPrice = entry.getBigDecimal("e_taxunitprice");
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, baseprecision);
            } else {
                BigDecimal unitPrice = entry.getBigDecimal("e_unitprice");
                calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, baseprecision);
            }
            localCalculator = new PriceLocalCalculator(calculator, exchangeRate, baseprecision);
            localCalculator.calculate();
            BigDecimal e_recAmount = localCalculator.getPricetaxtotal();
            BigDecimal e_localamt = localCalculator.getAmountlocal();
            BigDecimal e_reclocalamt = localCalculator.getPricetaxtotallocal();
            BigDecimal e_amount = localCalculator.getAmount();
            BigDecimal e_tax = localCalculator.getTax();
            BigDecimal e_unVerifyAmount = localCalculator.getAmount();
            BigDecimal e_unSettleAmount = localCalculator.getPricetaxtotal();
            recAmount = recAmount.add(e_recAmount);
            localamt = localamt.add(e_localamt);
            reclocalamt = reclocalamt.add(e_reclocalamt);
            unsettlelocalamt = unsettlelocalamt.add(e_reclocalamt);
            amount = amount.add(e_amount);
            tax = tax.add(e_tax);
            unVerifyAmount = unVerifyAmount.add(e_unVerifyAmount);
            unSettleAmount = unSettleAmount.add(e_unSettleAmount);
            BigDecimal quantity = entry.getBigDecimal("e_quantity");
            if (quantity == null) {
                quantity = BigDecimal.ZERO;
            }
            BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
            DynamicObject material = entry.getDynamicObject("e_material");
            DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
            if (!ObjectUtils.isEmpty((Object)material) && covertRate.compareTo(BigDecimal.ZERO) == 0) {
                DynamicObject baseUnit = material.getDynamicObject("baseunit");
                if (baseUnit != null) {
                    entry.set("e_baseunit", (Object)baseUnit);
                    if (measureUnit != null) {
                        covertRate = ArBillAmountReCalHelper.getUnitRateConv(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                        if (covertRate != null) {
                            entry.set("e_unitcoefficient", (Object)covertRate);
                            entry.set("e_baseunitqty", (Object)quantity.multiply(covertRate));
                        } else {
                            entry.set("e_unitcoefficient", (Object)1);
                            entry.set("e_baseunitqty", (Object)quantity);
                        }
                    }
                }
            } else {
                entry.set("e_baseunitqty", (Object)covertRate.multiply(quantity));
            }
            entry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
            entry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
            entry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
            entry.set("e_amount", (Object)e_amount);
            entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
            entry.set("e_tax", (Object)localCalculator.getTax());
            entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
            entry.set("e_recamount", (Object)e_recAmount);
            entry.set("e_reclocalamt", (Object)e_reclocalamt);
            entry.set("e_unverifyamt", (Object)amount);
            entry.set("e_unlockamt", (Object)e_recAmount);
            entry.set("e_unsettleamt", (Object)e_recAmount);
            entry.set("e_unsettlelocalamt", (Object)e_reclocalamt);
            entry.set("e_unitprice", (Object)localCalculator.getUnitprice());
            entry.set("e_unconfirmamt", (Object)amount);
            entry.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
            entry.set("e_unverifyqty", (Object)quantity);
            entry.set("e_uninvoicedamt", (Object)e_recAmount);
        }
        finArBill.set("recamount", (Object)recAmount);
        finArBill.set("reclocalamt", (Object)reclocalamt);
        finArBill.set("amount", (Object)amount);
        finArBill.set("localamt", (Object)localamt);
        finArBill.set("tax", (Object)tax);
        finArBill.set("unverifyamount", (Object)unVerifyAmount);
        finArBill.set("unsettleamount", (Object)unSettleAmount);
        finArBill.set("unsettlelocalamt", (Object)localamt);
        EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"ar_finarbill").findProperty("planentity");
        DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
        DynamicObject planEntry = new DynamicObject(dt);
        planEntry.set("planduedate", (Object)new Date());
        planEntry.set("planpricetax", (Object)recAmount);
        if (!ObjectUtils.isEmpty((Object)finArBill.getDynamicObject("settlementtype"))) {
            planEntry.set("plansettletype", (Object)finArBill.getDynamicObject("settlementtype"));
        }
        planEntry.set("planpricetaxloc", (Object)reclocalamt);
        planEntry.set("unplansettleamt", (Object)recAmount);
        planEntry.set("unplansettlelocamt", (Object)unsettlelocalamt);
        planEntry.set("unplanlockamt", (Object)recAmount);
    }

    public static BigDecimal getExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        if (srcCurrencyId == null || srcCurrencyId == 0L || destCurrencyId == null || destCurrencyId == 0L || srcCurrencyId.equals(destCurrencyId)) {
            return exchangeRate;
        }
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exratetableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        return exchangeRate;
    }

    private static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        DynamicObject muConv1 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        if (!ObjectUtils.isEmpty((Object)muConv1) && muConv1.getInt("numerator") != 0) {
            unitRate = muConv1.getBigDecimal("numerator").divide(muConv1.getBigDecimal("denominator"), 10, RoundingMode.HALF_UP);
        } else {
            DynamicObject muConv2 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)desUnitId, (Long)srcUnitId);
            if (!ObjectUtils.isEmpty((Object)muConv2) && muConv2.getInt("numerator") != 0) {
                unitRate = muConv2.getBigDecimal("denominator").divide(muConv2.getBigDecimal("numerator"), 10, RoundingMode.HALF_UP);
            }
        }
        return unitRate;
    }

    private static String getInitSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("startdate");
        return String.join((CharSequence)",", selectors);
    }

    private static DynamicObject getInitObj(DynamicObject org, String entity, DynamicObject tarabebtObject) {
        Object init = null;
        QFilter qFilter = new QFilter("org", "=", org.getPkValue());
        Object[] inits = BusinessDataServiceHelper.load((String)entity, (String)(ArBillAmountReCalHelper.getInitSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object[])inits)) {
            if (inits.length == 1) {
                init = inits[0];
            } else {
                for (Object obj : inits) {
                    DynamicObject policytype = obj.getDynamicObject("policytype");
                    if (policytype == null || !"master".equals(policytype.getString("type"))) continue;
                    init = obj;
                }
                if (init == null) {
                    init = inits[0];
                }
            }
        }
        return init;
    }
}

