/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.helper.recalprice.arap;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.scmc.ism.business.helper.recalprice.arap.AbstractPriceCalculator;

public class TaxUnitPriceCalculator
extends AbstractPriceCalculator {
    public TaxUnitPriceCalculator(BigDecimal quantity, BigDecimal taxunitprice, BigDecimal taxrate, String discountmode, BigDecimal discountrate, int currencyPrecision) {
        this.isTax = true;
        this.quantity = quantity.setScale(10, RoundingMode.HALF_UP);
        this.taxunitprice = taxunitprice.setScale(10, RoundingMode.HALF_UP);
        taxrate = taxrate.divide(ONE_HUNDRED);
        this.taxrate = taxrate.setScale(10, RoundingMode.HALF_UP);
        this.discountmode = discountmode;
        this.discountrate = discountrate.setScale(10, RoundingMode.HALF_UP);
        this.currencyPrecision = currencyPrecision;
    }

    @Override
    public void calculate() {
        this.unitprice = this.taxunitprice.divide(ONE.add(this.taxrate), 10, RoundingMode.HALF_UP);
        if ("PERCENT".equals(this.discountmode)) {
            this.discountamount = this.taxunitprice.multiply(this.quantity).multiply(this.discountrate.divide(ONE_HUNDRED)).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        } else if ("PERUNIT".equals(this.discountmode)) {
            this.discountamount = this.quantity.multiply(this.discountrate).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        }
        if (this.discountrate.compareTo(ONE_HUNDRED) != 0) {
            this.pricetaxtotal = this.taxunitprice.multiply(this.quantity).setScale(this.currencyPrecision, RoundingMode.HALF_UP).subtract(this.discountamount);
        }
        this.tax = this.pricetaxtotal.multiply(this.taxrate).divide(ONE.add(this.taxrate), 10, RoundingMode.HALF_UP).setScale(this.currencyPrecision, RoundingMode.HALF_UP);
        this.amount = this.pricetaxtotal.subtract(this.tax);
        if (this.discountrate.compareTo(BigDecimal.ZERO) == 0) {
            this.actunitprice = this.unitprice;
            this.acttaxunitprice = this.taxunitprice;
        } else {
            this.actunitprice = this.amount.divide(this.quantity, 10, RoundingMode.HALF_UP);
            this.acttaxunitprice = this.pricetaxtotal.divide(this.quantity, 10, RoundingMode.HALF_UP);
        }
    }
}

