/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.business.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.ism.common.selectstrategy.DefaultSelectStrategy;
import kd.scmc.ism.common.selectstrategy.IColsSelectStrategy;
import kd.scmc.ism.lang.CommonLang;

public class MetaHelper {
    private IColsSelectStrategy strategy;
    private MainEntityType meta;

    public MetaHelper(IColsSelectStrategy strategy, MainEntityType meta) {
        if (meta == null) {
            throw new KDBizException(CommonLang.getMsgMetaHelperError());
        }
        this.meta = meta;
        this.strategy = strategy == null ? new DefaultSelectStrategy() : strategy;
    }

    public MetaHelper(IColsSelectStrategy strategy, String metaNo) {
        this(strategy, MetadataServiceHelper.getDataEntityType((String)metaNo));
    }

    public MetaHelper(String metaNo) {
        this(null, metaNo);
    }

    public MetaHelper(MainEntityType meta) {
        this(null, meta);
    }

    private String getRootId() {
        return "0";
    }

    public String buildTree2JSON() {
        return SerializationUtils.toJsonString((Object)this.buildTree());
    }

    public TreeNode buildTree() {
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : allFields.values()) {
            parent = pro.getParent();
            if (parent instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro);
                continue;
            }
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
                TreeNode entryNode = this.getEntryNode(nodeMap, parent);
                this.strategy.buildNode4Entry(entryNode, pro);
                if (nodeMap.containsKey(entryNode.getId())) continue;
                nodeMap.put(entryNode.getId(), entryNode);
                root.addChild(entryNode);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            EntryType grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            TreeNode subEntryNode = this.getEntryNode(nodeMap, parent);
            TreeNode entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            this.strategy.buildNode4Entry(entryNode, subEntryNode, pro);
            if (nodeMap.containsKey(subEntryNode.getId())) continue;
            nodeMap.put(subEntryNode.getId(), subEntryNode);
            entryNode.addChild(subEntryNode);
        }
        return root;
    }

    private TreeNode getEntryNode(Map<String, TreeNode> nodeMap, IDataEntityType entryPro) {
        String entryName = entryPro.getName();
        TreeNode entryNode = nodeMap.get(entryName);
        if (entryNode == null) {
            entryNode = this.strategy.getTreeNode(this.getRootId(), entryName, entryPro.getDisplayName().toString());
            entryNode.setIsOpened(true);
        }
        return entryNode;
    }
}

