/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.scmc.ism.common.model.entity.PathPricingTree;
import kd.scmc.ism.common.model.log.PricingLogHandler;
import kd.scmc.ism.common.model.log.SettleLogHandler;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.PlainObjBillModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.unit.AbstractMatchUnit;
import kd.scmc.ism.model.relation.AbstractRelationModel;

public class ISMRequestContext {
    private Map<String, Set<Long>> reqBillIds = new HashMap<String, Set<Long>>(32);
    private Map<Long, PlainObjBillModel> srcPlainObjModels = new HashMap<Long, PlainObjBillModel>(16);
    private Map<Long, SettleBillModel> srcBillModels = new HashMap<Long, SettleBillModel>(32);
    private Map<Long, List<AbstractRelationModel>> relations = new HashMap<Long, List<AbstractRelationModel>>(16);
    private Map<Class<?>, Map<Long, MatchResult<?>>> matchedUnits = new HashMap(32);
    private Map<Long, SettleBillModel> generateBillModels = new HashMap<Long, SettleBillModel>(16);
    private List<CoupleSettleBillsModel> supDemBillInfos = new ArrayList<CoupleSettleBillsModel>(64);
    private List<SettleBillModel> toOutBills = new ArrayList<SettleBillModel>(32);
    private PathPricingTree pathPrirce = new PathPricingTree();
    private Map<Long, SettleLogHandler> settleLogs = new HashMap<Long, SettleLogHandler>(32);
    private PricingLogHandler pricingLogHandler = new PricingLogHandler();
    private Map<String, Object> customParams = new HashMap<String, Object>();
    private SettleOperResult operResult = new SettleOperResult();
    private Map<String, String> backGroundParams = new HashMap<String, String>();

    public static ISMRequestContext createRedo(String billtype, Collection<Long> billIds, Map<Long, SettleLogHandler> logHandlers, Map<Long, SettleBillModel> gbillModels) {
        ISMRequestContext reqContext = ISMRequestContext.create(billtype, billIds);
        reqContext.settleLogs.putAll(logHandlers);
        reqContext.generateBillModels.putAll(gbillModels);
        return reqContext;
    }

    public static ISMRequestContext create(String billtype, Collection<Long> billIds) {
        ISMRequestContext reqContext = ISMRequestContext.create();
        reqContext.reqBillIds.put(billtype, new HashSet<Long>(billIds));
        return reqContext;
    }

    public static ISMRequestContext create(List<SettleBillModel> billObjs) {
        ISMRequestContext reqContext = ISMRequestContext.create();
        for (SettleBillModel billObj : billObjs) {
            String billEntity = billObj.getBillEntityType();
            Set<Long> billIds = reqContext.reqBillIds.get(billEntity);
            if (billIds == null) {
                billIds = new HashSet<Long>(16);
                reqContext.reqBillIds.put(billEntity, billIds);
            }
            billIds.add(billObj.getId());
            reqContext.addSrcBillModel(billObj);
        }
        return reqContext;
    }

    public static ISMRequestContext create() {
        ISMRequestContext reqContext = new ISMRequestContext();
        return reqContext;
    }

    public Map<String, Set<Long>> getReqBillIds() {
        return this.reqBillIds;
    }

    public void addRelationModel(AbstractRelationModel model) {
        long billId = model.getBillModel().getId();
        CommonUtils.mapGetListValue(this.relations, billId).add(model);
    }

    public Map<Long, List<AbstractRelationModel>> getRelations() {
        return this.relations;
    }

    public void addSrcPlainObj(PlainObjBillModel billModel) {
        this.srcPlainObjModels.put(billModel.getId(), billModel);
    }

    public PlainObjBillModel getSrcPlainObjModels(Long billId) {
        return this.srcPlainObjModels.get(billId);
    }

    public void addSrcBillModel(SettleBillModel models) {
        this.srcBillModels.put(models.getId(), models);
    }

    public SettleBillModel getSrcBillModel(Long billId) {
        return this.srcBillModels.get(billId);
    }

    public Collection<SettleBillModel> getSrcBillModels() {
        return this.srcBillModels.values();
    }

    public void addSupDemBillInfo(CoupleSettleBillsModel cpBillModel) {
        SettleBillModel demBillModel;
        this.supDemBillInfos.add(cpBillModel);
        SettleBillModel supBillModel = (SettleBillModel)cpBillModel.getSupBillModel();
        if (supBillModel != null) {
            this.generateBillModels.put(supBillModel.getId(), supBillModel);
        }
        if ((demBillModel = (SettleBillModel)cpBillModel.getDemBillModel()) != null) {
            this.generateBillModels.put(demBillModel.getId(), demBillModel);
        }
    }

    public List<CoupleSettleBillsModel> getSupDemBillInfos() {
        return this.supDemBillInfos;
    }

    public void addToOutBill(SettleBillModel billModel) {
        this.toOutBills.add(billModel);
        this.generateBillModels.put(billModel.getId(), billModel);
    }

    public List<SettleBillModel> getToOutBills() {
        return this.toOutBills;
    }

    public Map<Long, SettleBillModel> getGenerateBillModels() {
        return this.generateBillModels;
    }

    public SettleLogHandler getLog(Long billId) {
        SettleBillModel srcBillModel;
        SettleLogHandler logHandler = this.settleLogs.get(billId);
        if (logHandler == null && (srcBillModel = this.getSrcBillModel(billId)) != null) {
            logHandler = SettleLogHandler.build(srcBillModel);
            this.settleLogs.put(billId, logHandler);
        }
        return logHandler;
    }

    public Map<Long, SettleLogHandler> getAllLogs() {
        return this.settleLogs;
    }

    public PricingLogHandler getPricingLogHandler() {
        return this.pricingLogHandler;
    }

    public void putCustomParam(String key, Object value) {
        this.customParams.put(key, value);
    }

    public Object getCustomParam(String key) {
        return this.customParams.get(key);
    }

    public Map<String, Object> getCustomParams() {
        return this.customParams;
    }

    public <T extends AbstractMatchUnit> void putMatchResult(Map<Long, MatchResult<T>> resultUnits) {
        for (Map.Entry<Long, MatchResult<T>> entryEntity : resultUnits.entrySet()) {
            this.putMatchResult(entryEntity.getKey(), entryEntity.getValue());
        }
    }

    public <T extends AbstractMatchUnit> void putMatchResult(Long id, MatchResult<T> unit) {
        Class<?> clazz = unit.getMatchedUnit().getClass();
        CommonUtils.mapGetMapValue(this.matchedUnits, clazz).put(id, unit);
    }

    public Map<Long, MatchResult<?>> getMatchUnits(Class<?> clazz) {
        return this.matchedUnits.get(clazz);
    }

    public SettleOperResult getOperResult() {
        return this.operResult;
    }

    public PathPricingTree getPathPrirce() {
        return this.pathPrirce;
    }

    public String getBackGroundParamValue(String key) {
        return this.backGroundParams.get(key);
    }

    public Map<String, String> getBackGroundParamValues() {
        return this.backGroundParams;
    }

    public void putBackGroundParam(String key, String value) {
        this.backGroundParams.put(key, value);
    }
}

