/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model;

import java.util.HashMap;
import java.util.Map;
import kd.scmc.ism.business.helper.CtrlInfoChecker;
import kd.scmc.ism.common.model.assist.MainBillAssistant;
import kd.scmc.ism.common.model.assist.OrgAssistant;
import kd.scmc.ism.common.model.assist.PurPolicyAssistant;
import kd.scmc.ism.common.model.assist.SalPolicyAssistant;
import kd.scmc.ism.common.model.assist.SettleCostAsisstant;
import kd.scmc.ism.common.model.mapper.DynamicObjectCacheMapper;
import kd.scmc.ism.common.model.mapper.ExRateCacheMapper;
import kd.scmc.ism.common.model.mapper.MaterialUnitConvertMapper;
import kd.scmc.ism.model.group.DataGroupClassfier;
import kd.scmc.ism.model.mapcfg.ModelMatchCfg;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;
import kd.scmc.ism.model.match.engine.impl.BizDirectMatchEngine;
import kd.scmc.ism.model.match.engine.impl.DynaRelationMatchEngine;
import kd.scmc.ism.model.match.engine.impl.GeneratePlanEntryMatchEngine;
import kd.scmc.ism.model.match.engine.impl.SettleJudgeMatchEngine;

public class ISMServiceContext {
    private Map<Class<?>, Object> services = new HashMap(16);
    private SettleBillMapCfg mapCfg = null;
    private ModelMatchCfg matchCfg = null;
    private DataGroupClassfier classfier = null;
    private DynaRelationMatchEngine dynaRelationEngine = null;
    private MainBillAssistant billAssistant = null;
    private SettleCostAsisstant scAssistant = null;

    public static ISMServiceContext build() {
        ISMServiceContext settleBizContext = new ISMServiceContext();
        settleBizContext.initService();
        settleBizContext.initMatchEngine();
        return settleBizContext;
    }

    public static ISMServiceContext buildOnlyService() {
        ISMServiceContext settleBizContext = new ISMServiceContext();
        settleBizContext.initService();
        return settleBizContext;
    }

    public static ISMServiceContext buildCheck() {
        ISMServiceContext settleBizContext = new ISMServiceContext();
        settleBizContext.initService();
        settleBizContext.initCheckMatchEngine();
        return settleBizContext;
    }

    private ISMServiceContext() {
    }

    private void initService() {
        this.addService(new DynamicObjectCacheMapper());
        this.addService(new ExRateCacheMapper());
        this.addService(new OrgAssistant());
        this.addService(new PurPolicyAssistant());
        this.addService(new SalPolicyAssistant());
        this.addService(new CtrlInfoChecker());
        this.addService(new MaterialUnitConvertMapper());
    }

    private void initCheckMatchEngine() {
        this.addService(SettleJudgeMatchEngine.buildIgnoreStatus(new String[0]));
        this.addService(BizDirectMatchEngine.build(new String[0]));
    }

    private void initMatchEngine() {
        this.addService(SettleJudgeMatchEngine.build(new String[0]));
        this.addService(BizDirectMatchEngine.build(new String[0]));
        this.addService(GeneratePlanEntryMatchEngine.build());
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.services.get(clazz);
    }

    protected void addService(Object service) {
        this.services.put(service.getClass(), service);
    }

    public OrgAssistant getOrgAssistant() {
        return this.getService(OrgAssistant.class);
    }

    public CtrlInfoChecker getCtrlInfos() {
        return this.getService(CtrlInfoChecker.class);
    }

    public SettleBillMapCfg getMapCfg() {
        if (this.mapCfg == null) {
            this.mapCfg = SettleBillMapCfg.buildAll();
        }
        return this.mapCfg;
    }

    public ModelMatchCfg getMatchCfg() {
        if (this.matchCfg == null) {
            this.matchCfg = ModelMatchCfg.build();
        }
        return this.matchCfg;
    }

    public DataGroupClassfier getClassfier() {
        if (this.classfier == null) {
            this.classfier = DataGroupClassfier.create();
        }
        return this.classfier;
    }

    public MainBillAssistant getBillAssistant() {
        if (this.billAssistant == null) {
            this.billAssistant = new MainBillAssistant(this.getMapCfg());
        }
        return this.billAssistant;
    }

    public SettleCostAsisstant getSettleCostAssistant() {
        if (this.scAssistant == null) {
            this.scAssistant = SettleCostAsisstant.build(this.getMapCfg());
        }
        return this.scAssistant;
    }

    public DynaRelationMatchEngine getDynaRelationEngine() {
        if (this.dynaRelationEngine == null) {
            this.dynaRelationEngine = DynaRelationMatchEngine.build(this.getClassfier(), this.getCtrlInfos());
        }
        return this.dynaRelationEngine;
    }
}

