/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.args;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;

public class GenerateResult {
    private String billType = null;
    private SettleBillModel bill = null;
    private boolean result = false;
    private String failReason = "";
    private String botpid = null;
    private DynamicObject bizFlow = null;

    public static GenerateResult createFailResult(String failReason) {
        if (failReason != null && failReason.length() >= 1500) {
            failReason = failReason.substring(0, 1497) + "...";
        }
        return new GenerateResult(false, null, failReason);
    }

    public static GenerateResult createSuccessResult(DynamicObject bill, SettleBillMapCfg mapcfg) {
        GenerateResult result = new GenerateResult(true, SettleBillModel.build(bill, mapcfg), null);
        return result;
    }

    public GenerateResult(String failReason) {
        this(false, null, failReason);
    }

    public GenerateResult(SettleBillModel bill) {
        this(true, bill, null);
    }

    private GenerateResult(boolean result, SettleBillModel bill, String failReason) {
        this.bill = bill;
        this.result = result;
        this.failReason = failReason;
    }

    public boolean isSuccess() {
        return this.result && this.bill != null;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public boolean isResult() {
        return this.result;
    }

    public String getBotpid() {
        return this.botpid;
    }

    public void setBotpid(String botpid) {
        this.botpid = botpid;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public SettleBillModel getBill() {
        return this.bill;
    }

    public void setFailReason(String failReason) {
        this.result = false;
        this.failReason = failReason.length() >= 1500 ? failReason.substring(0, 1497).concat("...") : failReason;
    }

    public String toString() {
        return "GenerateResult [bill=" + this.bill + ", result=" + this.result + ", failReason=" + this.failReason + "]";
    }

    public void setBizFlow(DynamicObject bizFlowKey) {
        this.bizFlow = bizFlowKey;
    }

    public DynamicObject getBizFlow() {
        return this.bizFlow;
    }
}

