/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.assist;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.common.errocode.ISMErrorCode;
import kd.scmc.ism.common.model.assist.AbstractPrcingAssistant;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;
import kd.scmc.ism.model.mapcfg.fieldinfo.BillFieldInfo;

public abstract class AbstractPolicyPricingAssistant
extends AbstractPrcingAssistant {
    public static final String[] QUOTE_FIELD = new String[]{"unit", "settlecy", "priceandtax", "price", "taxrateid"};

    protected abstract Long getMainOrg(CoupleSettleBillEntriesModel var1);

    protected abstract SettleBillEntryModel getPricingModel(CoupleSettleBillEntriesModel var1);

    @Override
    protected String getCacheKey(CoupleSettleBillEntriesModel model) {
        return this.getCacheKey(this.getMainOrg(model), model);
    }

    protected String getCacheKey(Long orgId, CoupleSettleBillEntriesModel model) {
        StringBuilder strs = new StringBuilder();
        strs.append(orgId);
        strs.append("_");
        strs.append(model.getId());
        return strs.toString();
    }

    @Override
    protected void doQuote() {
        Map<Long, Map<String, List<CoupleSettleBillEntriesModel>>> splitParams = this.splitBillInfo(this.cpBills.values());
        if (splitParams.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Map<String, List<CoupleSettleBillEntriesModel>>> orgToEntry : splitParams.entrySet()) {
            Long orgId = orgToEntry.getKey();
            for (Map.Entry<String, List<CoupleSettleBillEntriesModel>> entityToObjects : orgToEntry.getValue().entrySet()) {
                String entity = entityToObjects.getKey();
                List<CoupleSettleBillEntriesModel> enties = entityToObjects.getValue();
                DynamicObject[] objs = this.getBillObjs(enties);
                Map<String, Object> callQuoteResult = null;
                try {
                    callQuoteResult = this.callQuoteService(new Object[]{orgId, objs, entity, Boolean.FALSE});
                    this.parseResult(enties, entity, callQuoteResult);
                }
                catch (KDBizException e) {
                    for (CoupleSettleBillEntriesModel entry : enties) {
                        String checkKey = this.getCacheKey(orgId, entry);
                        this.failInfos.put(checkKey, e.getErrorCode().getMessage());
                    }
                }
            }
        }
        this.cpBills.clear();
    }

    private Map<Long, Map<String, List<CoupleSettleBillEntriesModel>>> splitBillInfo(Collection<CoupleSettleBillEntriesModel> cpBills) {
        HashMap<Long, Map<String, List<CoupleSettleBillEntriesModel>>> splitParams = new HashMap<Long, Map<String, List<CoupleSettleBillEntriesModel>>>(16);
        for (CoupleSettleBillEntriesModel entryModel : cpBills) {
            Long orgId = this.getMainOrg(entryModel);
            String cacheKey = this.getCacheKey(orgId, entryModel);
            if (this.pricingResult.containsKey(cacheKey) || this.failInfos.containsKey(cacheKey)) continue;
            SettleBillEntryModel pricingEntryModel = this.getPricingModel(entryModel);
            if (pricingEntryModel == null) {
                this.failInfos.put(cacheKey, PricingLang.notOppoEntryInfo());
                continue;
            }
            SettleBillModel billModel = pricingEntryModel.getBillModel();
            String billEntityType = billModel.getBillEntityType();
            Map<String, List<CoupleSettleBillEntriesModel>> billMaps = CommonUtils.mapGetMapValue(splitParams, orgId);
            List<CoupleSettleBillEntriesModel> bills = CommonUtils.mapGetListValue(billMaps, billEntityType);
            bills.add(entryModel);
        }
        return splitParams;
    }

    private DynamicObject[] getBillObjs(List<CoupleSettleBillEntriesModel> enties) {
        HashMap<Long, DynamicObject> bills = new HashMap<Long, DynamicObject>(16);
        for (CoupleSettleBillEntriesModel cpModel : enties) {
            SettleBillModel billModel = this.getPricingModel(cpModel).getBillModel();
            bills.put(billModel.getId(), billModel.getObj());
        }
        return bills.values().toArray(new DynamicObject[bills.size()]);
    }

    private Map<String, Object> callQuoteService(Object[] param) throws KDBizException {
        String failReason = null;
        boolean isSuccess = true;
        Map priceMap = null;
        try {
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\uff1a\u8c03\u7528\u91c7\u8d2d\u3001\u9500\u552e\u53d6\u4ef7\u63a5\u53e3\u53c2\u6570\uff1a" + Arrays.toString(param));
            priceMap = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"plat", (String)"QuoteService", (String)"quoteByDynObj", (Object[])param);
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\uff1a\u8c03\u7528\u91c7\u8d2d\u3001\u9500\u552e\u53d6\u4ef7\u63a5\u53e3\u7ed3\u679c\uff1a" + priceMap);
            failReason = (String)priceMap.get("msg");
            if (StringUtils.isNotEmpty((CharSequence)failReason)) {
                isSuccess = false;
            }
        }
        catch (Exception e) {
            isSuccess = false;
            failReason = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        if (!isSuccess) {
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\uff1a\u8c03\u7528\u91c7\u8d2d\u3001\u9500\u552e\u53d6\u4ef7\u63a5\u53e3\u5931\u8d25\uff1a" + param[0] + "-" + param[2] + "[" + failReason + "]");
            throw new KDBizException(ISMErrorCode.quotePurSalFail(failReason), new Object[0]);
        }
        return priceMap;
    }

    private void parseResult(Collection<CoupleSettleBillEntriesModel> cpBills, String entity, Map<String, Object> result) {
        for (CoupleSettleBillEntriesModel entryModel : cpBills) {
            Long mainOrg = this.getMainOrg(entryModel);
            SettleBillEntryModel pricingModel = this.getPricingModel(entryModel);
            if (pricingModel == null) continue;
            HashMap<String, Object> quoteValues = new HashMap<String, Object>(16);
            for (String quoteField : QUOTE_FIELD) {
                Object value = result.get(this.getQuotePriceKey(pricingModel, quoteField));
                quoteValues.put(quoteField, value);
            }
            this.pricingResult.put(this.getCacheKey(mainOrg, entryModel), quoteValues);
        }
    }

    protected final String getQuotePriceKey(SettleBillEntryModel entryModel, String quotefield) {
        SettleBillMapCfg mapCfg = entryModel.getMapCfg();
        SettleBillModel billModel = entryModel.getBillModel();
        BillFieldInfo fieldInfo = mapCfg.getSrcFieldInfo(billModel.getBillEntityType(), quotefield);
        Long billId = billModel.getId();
        StringBuilder strs = new StringBuilder();
        if (fieldInfo == null) {
            return null;
        }
        String field = fieldInfo.getBillFieldKey();
        if (fieldInfo.isBillHead()) {
            strs.append(billId);
            strs.append("_");
            strs.append(field);
        } else {
            Long entryId = entryModel.getId();
            int seq = entryModel.getObj().getInt("seq");
            strs.append(billId);
            strs.append("_");
            strs.append(entryId);
            strs.append("_");
            strs.append(seq);
            strs.append("_");
            strs.append(field);
        }
        return strs.toString();
    }
}

