/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.assist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.ReportLang;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;
import kd.scmc.ism.model.mapcfg.fieldinfo.BillFieldInfo;

public class MainBillAssistant {
    private SettleBillMapCfg billCfg = null;
    private Map<String, Set<Long>> mainBillIds = new HashMap<String, Set<Long>>();
    private Map<String, Map<Long, SettleBillModel>> mainBills = new HashMap<String, Map<Long, SettleBillModel>>();

    public MainBillAssistant(SettleBillMapCfg billCfg) {
        this.billCfg = billCfg;
    }

    public void preLoadData(String entity, Long billId) {
        CommonUtils.mapGetSetValue(this.mainBillIds, entity).add(billId);
    }

    public void preLoadDatas(String entity, Collection<Long> billIds) {
        CommonUtils.mapGetSetValue(this.mainBillIds, entity).addAll(billIds);
    }

    private void doloadData(String entity) {
        DynamicObject[] mainObjects;
        Map<Long, SettleBillModel> loadedBill = CommonUtils.mapGetMapValue(this.mainBills, entity);
        Set<Long> mianIds = CommonUtils.mapGetSetValue(this.mainBillIds, entity);
        mianIds.removeAll(loadedBill.keySet());
        if (mianIds.isEmpty()) {
            return;
        }
        for (DynamicObject mainObj : mainObjects = BusinessDataServiceHelper.load((String)entity, (String)this.buildSelectFields(entity), (QFilter[])new QFilter("id", "in", mianIds).toArray())) {
            Long id = (Long)mainObj.getPkValue();
            SettleBillModel model = SettleBillModel.build(mainObj, this.billCfg);
            loadedBill.put(id, model);
        }
        mianIds.clear();
    }

    public SettleBillModel getMainBillObj(String entity, Long billId) {
        Map<Long, SettleBillModel> loadedBill = CommonUtils.mapGetMapValue(this.mainBills, entity);
        if (!loadedBill.containsKey(billId)) {
            CommonUtils.mapGetSetValue(this.mainBillIds, entity).add(billId);
            this.doloadData(entity);
        }
        return loadedBill.get(billId);
    }

    public SettleBillMapCfg getBillCfg() {
        return this.billCfg;
    }

    private String buildSelectFields(String entity) {
        HashSet<String> selectFields = new HashSet<String>(16);
        selectFields.add("id");
        List<String> mapCfgFields = Arrays.asList("number", "price", "priceandtax", "taxrate", "taxrateid", "basecurrency", "settlecy", "unit", "mainbizorg");
        if (this.billCfg == null) {
            throw new KDBizException("SettleBillMapCfg is null");
        }
        Map<String, BillFieldInfo> fieldMap = this.billCfg.getBillFieldInfoMap(entity);
        BasedataEntityType billEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");
        ArrayList<IDataEntityProperty> notConfigProp = new ArrayList<IDataEntityProperty>(16);
        for (String mapField : mapCfgFields) {
            BillFieldInfo fieldInfo = fieldMap.get(mapField);
            if (fieldInfo == null) {
                DynamicProperty property = billEntityType.getProperty(mapField);
                if (property == null) continue;
                notConfigProp.add((IDataEntityProperty)property);
                continue;
            }
            selectFields.add(fieldInfo.getSrcBillFieldKey());
        }
        if (!notConfigProp.isEmpty()) {
            throw new KDBizException(ReportLang.noConfigBillFieldMapping((BillEntityType)EntityMetadataCache.getDataEntityType((String)entity), notConfigProp));
        }
        return selectFields.stream().collect(Collectors.joining(","));
    }
}

