/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.assist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.common.model.assist.AbstractPrcingAssistant;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.ISettleBillModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;

public class SettleCostAsisstant
extends AbstractPrcingAssistant {
    private Map<String, Map<String, String>> costHeadBillFieldMap = null;
    private Map<String, Map<String, String>> costEntryBillFieldMap = null;
    private SettleBillMapCfg mapCfg;

    public static SettleCostAsisstant build(SettleBillMapCfg mapCfg) {
        SettleCostAsisstant assist = new SettleCostAsisstant(mapCfg);
        assist.loadCostBillFieldMap();
        return assist;
    }

    private SettleCostAsisstant(SettleBillMapCfg mapCfg) {
        this.mapCfg = mapCfg;
    }

    private void loadCostBillFieldMap() {
        Set<String> billEntitys = this.mapCfg.getBillEntitys();
        Map resultMapping = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getBillFields", (Object[])new Object[]{new HashSet<String>(billEntitys)});
        this.costHeadBillFieldMap = new HashMap<String, Map<String, String>>(16);
        this.costEntryBillFieldMap = new HashMap<String, Map<String, String>>(16);
        if (CommonUtils.mapIsEmpty(resultMapping)) {
            return;
        }
        for (Map.Entry entity : resultMapping.entrySet()) {
            String entityName = (String)entity.getKey();
            String billentryName = this.mapCfg.getFieldKey(entityName, "billentry");
            this.parseCalMapField(entityName, (Map)entity.getValue(), billentryName);
        }
    }

    private void parseCalMapField(String key, Map<String, String> value, String billentryName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)key);
        String entityName = dataEntityType.getName();
        HashMap<String, String> headMap = new HashMap<String, String>(16);
        HashMap<String, String> entryMap = new HashMap<String, String>(16);
        for (Map.Entry<String, String> fieldKeys : value.entrySet()) {
            String costfieldKey = fieldKeys.getKey();
            String billfieldKey = fieldKeys.getValue();
            IDataEntityProperty findProperty = dataEntityType.findProperty(billfieldKey);
            String parentKey = findProperty.getParent().getName();
            if (StringUtils.isEmpty((CharSequence)parentKey)) continue;
            if (parentKey.equals(entityName)) {
                headMap.put(costfieldKey, billfieldKey);
                continue;
            }
            if (!parentKey.equals(billentryName)) continue;
            entryMap.put(costfieldKey, DynamicObjectUtil.getLastKey(billfieldKey));
        }
        this.costHeadBillFieldMap.put(entityName, headMap);
        this.costEntryBillFieldMap.put(entityName, entryMap);
    }

    @Override
    protected String getCacheKey(CoupleSettleBillEntriesModel model) {
        return String.valueOf(model.getId());
    }

    @Override
    protected void doQuote() {
        ArrayList<CoupleSettleBillEntriesModel> prepareEntry = new ArrayList<CoupleSettleBillEntriesModel>(this.cpBills.size());
        HashMap<Long, Map<String, Object>> allparams = new HashMap<Long, Map<String, Object>>(this.cpBills.size());
        for (CoupleSettleBillEntriesModel entryModel : this.cpBills.values()) {
            try {
                Map<String, Object> params = this.buildParam(entryModel);
                prepareEntry.add(entryModel);
                allparams.put(entryModel.getId(), params);
            }
            catch (KDBizException e) {
                this.failInfos.put(this.getCacheKey(entryModel), e.getMessage());
            }
        }
        Map costPriceResult = new HashMap();
        try {
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\uff1a\u8c03\u7528\u6838\u7b97\u6210\u672c\u4ef7\u53d6\u4ef7\u670d\u52a1\u53c2\u6570\uff1a" + allparams);
            costPriceResult = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getPrice", (Object[])new Object[]{allparams});
            log.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\uff1a\u8c03\u7528\u6838\u7b97\u6210\u672c\u4ef7\u53d6\u4ef7\u670d\u52a1\u7ed3\u679c\uff1a" + costPriceResult);
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\uff1a\u8c03\u7528\u6838\u7b97\u6210\u672c\u4ef7\u53d6\u4ef7\u670d\u52a1\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            for (CoupleSettleBillEntriesModel entryModel : prepareEntry) {
                this.failInfos.put(this.getCacheKey(entryModel), PricingLang.pricingCallFail(e));
            }
            return;
        }
        for (CoupleSettleBillEntriesModel entryModel : prepareEntry) {
            Map result = (Map)costPriceResult.get(entryModel.getId());
            String cacheKey = this.getCacheKey(entryModel);
            if (CommonUtils.mapIsEmpty(result)) {
                String failReason = ResManager.loadKDString((String)"\u6838\u7b97\u53d6\u4ef7\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"CostPricingReturnNull", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.failInfos.put(cacheKey, failReason);
                continue;
            }
            Object price = result.get("price");
            Object currencyId = result.get("currency");
            Object unitId = result.get("unit");
            if (price == null || currencyId == null) {
                String failReason = ResManager.loadKDString((String)"\u6838\u7b97\u53d6\u4ef7\u672a\u8fd4\u56de\u4ef7\u683c\u6216\u5bf9\u5e94\u5e01\u79cd\uff0c\u65e0\u6cd5\u8fdb\u884c\u6c47\u7387\u6362\u7b97\u3002", (String)"CostPricingNotReturnCurrency", (String)"scmc-ism-form", (Object[])new Object[0]);
                this.failInfos.put(cacheKey, failReason);
                continue;
            }
            HashMap quoteValues = new HashMap(16);
            if (!(price instanceof BigDecimal)) {
                price = BigDecimal.valueOf(Long.parseLong(price.toString()));
            }
            quoteValues.put("unit", unitId);
            quoteValues.put("settlecy", currencyId);
            quoteValues.put("priceandtax", price);
            quoteValues.put("price", price);
            this.pricingResult.put(cacheKey, quoteValues);
        }
    }

    public Map<String, Object> buildParam(CoupleSettleBillEntriesModel cpModels) throws KDBizException {
        SettleBillEntryModel supGenEntry = (SettleBillEntryModel)cpModels.getSupBillModel();
        if (supGenEntry == null) {
            String failReason = ResManager.loadKDString((String)"\u4f9b\u65b9\u5206\u5f55\u7f3a\u5931\uff0c\u65e0\u6cd5\u83b7\u53d6\u6838\u7b97\u6210\u672c\u4ef7\u683c\u3002", (String)"NotSupplierEntry", (String)"scmc-ism-form", (Object[])new Object[0]);
            throw new KDBizException(failReason);
        }
        SettleBillModel billModel = supGenEntry.getBillModel();
        String billEntityType = billModel.getBillEntityType();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.putAll(this.getPricingParam(supGenEntry.getBillModel(), this.costHeadBillFieldMap.get(billEntityType)));
        params.putAll(this.getPricingParam(supGenEntry, this.costEntryBillFieldMap.get(billEntityType)));
        if (CommonUtils.mapIsEmpty(params)) {
            String failReason = ResManager.loadKDString((String)"\u6ca1\u6709\u5728\u6838\u7b97\u914d\u7f6e\u53c2\u6570\uff0c\u53d6\u6838\u7b97\u6210\u672c\u4ef7\u5931\u8d25\u3002", (String)"NotCostPricingParamConfig", (String)"scmc-ism-form", (Object[])new Object[0]);
            throw new KDBizException(failReason);
        }
        params.put("entityobject", billEntityType);
        return params;
    }

    private Map<String, Object> getPricingParam(ISettleBillModel model, Map<String, String> billKeyMap) {
        if (CommonUtils.mapIsEmpty(billKeyMap)) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(billKeyMap.size());
        for (Map.Entry<String, String> headMap : billKeyMap.entrySet()) {
            String key = headMap.getKey();
            Object value = model.getObj().get(headMap.getValue());
            if (value instanceof DynamicObject) {
                value = DynamicObjectUtil.getPkValue(DynamicObjectUtil.getMaterialMasterObject((DynamicObject)value));
            }
            paramMap.put(key, value);
        }
        return paramMap;
    }
}

