/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.billgenerator;

import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.billgenerator.BillGenerator;
import kd.scmc.ism.common.model.billgenerator.impl.BOTPBillGenerator;
import kd.scmc.ism.common.model.billgenerator.impl.ErroMessageBillGenerator;
import kd.scmc.ism.common.model.mapper.DynamicObjectCacheMapper;
import kd.scmc.ism.lang.ModelLang;

public class GeneratorFactory {
    public static BillGenerator build(ISMServiceContext serviceContext, DynamicObject planEntry) {
        BillGenerator generator = null;
        DynamicObject sourcetype = planEntry.getDynamicObject("sourcebilltype");
        DynamicObject targettype = planEntry.getDynamicObject("targetbilltype");
        String sourcebilltype = sourcetype.getString("number");
        String targetbilltype = targettype.getString("number");
        DynamicObject botpRule = planEntry.getDynamicObject("botpid");
        DynamicObject billgenerator = planEntry.getDynamicObject("billgenerator");
        if (botpRule != null) {
            BOTPBillGenerator botpBillGenerator = new BOTPBillGenerator();
            botpBillGenerator.setBotpid(botpRule.getString("id"));
            generator = botpBillGenerator;
        } else if (billgenerator != null) {
            DynamicObjectCacheMapper doservice = serviceContext.getService(DynamicObjectCacheMapper.class);
            billgenerator = doservice.get("ism_settlebillprocessor", billgenerator.getPkValue());
            String clazz = billgenerator.getString("processorclass");
            try {
                generator = (BillGenerator)TypesContainer.getOrRegisterSingletonInstance((String)clazz);
            }
            catch (Exception e) {
                generator = new ErroMessageBillGenerator(e);
            }
        } else {
            generator = new ErroMessageBillGenerator(ModelLang.generateTypeNotConfig());
        }
        generator.setSourceBillType(sourcebilltype);
        generator.setTargetBillType(targetbilltype);
        return generator;
    }
}

