/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.scmc.ism.common.model.tree.InfoTreeNode;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public class PathPricingTree {
    private Map<Long, InfoTreeNode<CoupleSettleBillEntriesModel>> nodes = new HashMap<Long, InfoTreeNode<CoupleSettleBillEntriesModel>>(16);
    private Set<Long> subNodeIds = new HashSet<Long>(16);

    public void add(CoupleSettleBillEntriesModel src, CoupleSettleBillEntriesModel cur) {
        InfoTreeNode<CoupleSettleBillEntriesModel> curNode;
        InfoTreeNode<CoupleSettleBillEntriesModel> srcNode = this.nodes.get(src.getId());
        if (srcNode == null) {
            srcNode = new InfoTreeNode<CoupleSettleBillEntriesModel>(String.valueOf(src.getId()), src);
            this.nodes.put(src.getId(), srcNode);
        }
        if ((curNode = this.nodes.get(cur.getId())) == null) {
            curNode = new InfoTreeNode<CoupleSettleBillEntriesModel>(String.valueOf(cur.getId()), cur);
            this.nodes.put(cur.getId(), curNode);
        }
        srcNode.addSubNode(curNode);
        this.subNodeIds.add(cur.getId());
    }

    public List<InfoTreeNode<CoupleSettleBillEntriesModel>> getRoot() {
        ArrayList<InfoTreeNode<CoupleSettleBillEntriesModel>> roots = new ArrayList<InfoTreeNode<CoupleSettleBillEntriesModel>>(16);
        for (Map.Entry<Long, InfoTreeNode<CoupleSettleBillEntriesModel>> node : this.nodes.entrySet()) {
            if (this.subNodeIds.contains(node.getKey())) continue;
            roots.add(node.getValue());
        }
        return roots;
    }

    public List<InfoTreeNode<CoupleSettleBillEntriesModel>> getSubNodes() {
        ArrayList<InfoTreeNode<CoupleSettleBillEntriesModel>> subNodes = new ArrayList<InfoTreeNode<CoupleSettleBillEntriesModel>>(16);
        for (Long subNodeId : this.subNodeIds) {
            subNodes.add(this.nodes.get(subNodeId));
        }
        return subNodes;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public boolean isContain(CoupleSettleBillEntriesModel cpModel) {
        return this.subNodeIds.contains(cpModel.getId());
    }
}

