/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.common.utils.CommonUtils;

public class BillFieldMapCfg {
    private Map<String, Map<String, String>> fieldMap;
    private Map<String, Map<String, String>> fieldEndNumMap;
    private Set<String> srcBillDataNums;

    public BillFieldMapCfg(Set<String> srcBillDataNums) {
        this.srcBillDataNums = new HashSet<String>();
        if (CommonUtils.collectionIsEmpty(srcBillDataNums)) {
            return;
        }
        this.srcBillDataNums.addAll(srcBillDataNums);
    }

    public BillFieldMapCfg() {
    }

    public static BillFieldMapCfg buildAll() {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sbs_billfieldmapping", (String)"sourcebill", (QFilter[])new QFilter("targetobj", "=", (Object)"ism_billmapcfg").toArray());
        BillFieldMapCfg cfg = null;
        if (CommonUtils.collectionIsEmpty(query)) {
            cfg = new BillFieldMapCfg();
        } else {
            HashSet<String> bills = new HashSet<String>(query.size());
            for (DynamicObject obj : query) {
                bills.add(obj.getString("sourcebill"));
            }
            cfg = new BillFieldMapCfg(bills);
            cfg.updateFieldMap();
        }
        return cfg;
    }

    public void addSrcBillDataNum(String srcBillDataNum) {
        if (this.srcBillDataNums == null) {
            this.srcBillDataNums = new HashSet<String>(16);
        }
        if (StringUtils.isBlank((CharSequence)srcBillDataNum) || this.srcBillDataNums.contains(srcBillDataNum)) {
            return;
        }
        this.srcBillDataNums.add(srcBillDataNum);
    }

    private void updateFieldMap() {
        this.updateFieldMap(this.srcBillDataNums);
    }

    private void updateFieldMap(Set<String> addBillDataNums) {
        QFilter qFilter1 = new QFilter("targetobj.number", "=", (Object)"ism_billmapcfg");
        QFilter qFilter2 = new QFilter("bizapp.number", "=", (Object)"ism");
        QFilter qFilter3 = new QFilter("isenable", "=", (Object)Boolean.TRUE);
        QFilter qFilter4 = new QFilter("sourcebill.number", "in", addBillDataNums);
        Map billFieldsMap = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4});
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap<String, Map<String, String>>(addBillDataNums.size());
        }
        if (billFieldsMap.isEmpty()) {
            return;
        }
        for (DynamicObject billFields : billFieldsMap.values()) {
            HashMap<String, String> billFieldMap = new HashMap<String, String>(16);
            DynamicObjectCollection colsMap = billFields.getDynamicObjectCollection("colsmap");
            for (DynamicObject cols : colsMap) {
                billFieldMap.put(cols.getString("targetobjcol"), cols.getString("sourcebillcol"));
            }
            this.fieldMap.put(billFields.getString("sourcebill.number"), billFieldMap);
        }
    }

    public String getSrcFieldNum(String srcBillDataNum, String fieldKey) {
        Map<String, String> srcFields = this.getSrcBillDataMap(srcBillDataNum);
        if (srcFields == null || srcFields.isEmpty()) {
            return null;
        }
        return srcFields.get(fieldKey);
    }

    public Map<String, String> getSrcBillDataMap(String srcBillDataNum) {
        this.addSrcBillDataNum(srcBillDataNum);
        if (this.fieldMap == null) {
            this.updateFieldMap(this.srcBillDataNums);
        } else if (this.fieldMap.size() < this.srcBillDataNums.size()) {
            HashSet<String> addNumSet = new HashSet<String>(this.srcBillDataNums.size() - this.fieldMap.size());
            addNumSet.addAll(this.srcBillDataNums);
            addNumSet.removeAll(this.fieldMap.keySet());
            this.updateFieldMap(addNumSet);
        }
        return this.fieldMap.get(srcBillDataNum);
    }

    public Map<String, String> getSrcFieldEndNumMap(String srcBillDataNum) {
        this.fieldEndNumMap = this.fieldEndNumMap == null ? new HashMap() : this.fieldEndNumMap;
        Map<String, String> fieldEndMap = this.fieldEndNumMap.get(srcBillDataNum);
        if (fieldEndMap != null) {
            return fieldEndMap;
        }
        Map<String, String> srcFields = this.getSrcBillDataMap(srcBillDataNum);
        fieldEndMap = new HashMap<String, String>(srcFields.size());
        if (srcFields == null || srcFields.isEmpty()) {
            return fieldEndMap;
        }
        for (Map.Entry<String, String> entry : srcFields.entrySet()) {
            String srcFieldNum = entry.getValue();
            if (StringUtils.isBlank((CharSequence)srcFieldNum)) continue;
            String[] split = srcFieldNum.split("\\.");
            fieldEndMap.put(entry.getKey(), split[split.length - 1]);
        }
        return fieldEndMap;
    }

    public Set<String> getBillEntitys() {
        HashSet<String> sets = new HashSet<String>(16);
        if (this.fieldMap != null) {
            sets.addAll(this.fieldMap.keySet());
        }
        return sets;
    }
}

