/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.handler;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.scmc.ism.common.model.tree.InfoTreeNode;
import kd.scmc.ism.common.utils.DynamicObjectUtil;

public class BillFieldResetRuleHandler {
    private DynamicObject obj;
    private InfoTreeNode<Map<String, String>> billMapInfo = null;

    public static BillFieldResetRuleHandler build(DynamicObject obj) {
        BillFieldResetRuleHandler handler = new BillFieldResetRuleHandler(obj);
        handler.init();
        return handler;
    }

    private BillFieldResetRuleHandler(DynamicObject obj) {
        this.obj = obj;
    }

    private void init() {
        String entityName = this.obj.getDynamicObject("targetbill").getString("number");
        DynamicObjectCollection resetRules = this.obj.getDynamicObjectCollection("entryentity");
        this.billMapInfo = new InfoTreeNode(entityName, new HashMap(resetRules.size()));
        for (DynamicObject resetRule : resetRules) {
            String targetFieldKey = resetRule.getString("targetfiledkey");
            String value = resetRule.getString("constants");
            String[] fields = targetFieldKey.split("\\.");
            int length = fields.length;
            if (1 == length) {
                this.billMapInfo.getValue().put(fields[0], value);
                continue;
            }
            if (2 != length) continue;
            String entryInfo = fields[0];
            String fieldName = fields[1];
            InfoTreeNode<Map<String, String>> subNode = this.billMapInfo.getSubNode(entryInfo);
            if (subNode == null) {
                subNode = new InfoTreeNode(entryInfo, new HashMap(resetRules.size()));
                this.billMapInfo.addSubNode(subNode);
            }
            subNode.getValue().put(fieldName, value);
        }
    }

    public DynamicObject resetBillField(DynamicObject bill) {
        if (this.billMapInfo == null) {
            return bill;
        }
        Map<String, String> headMapInfo = this.billMapInfo.getValue();
        this.resetValue(bill, headMapInfo);
        Collection<InfoTreeNode<Map<String, String>>> allSubNodes = this.billMapInfo.getAllSubNodes();
        for (InfoTreeNode<Map<String, String>> infoTreeNode : allSubNodes) {
            Map<String, String> entryMapInfo = infoTreeNode.getValue();
            String key = infoTreeNode.getKey();
            DynamicObjectCollection collection = bill.getDynamicObjectCollection(key);
            for (DynamicObject entry : collection) {
                this.resetValue(entry, entryMapInfo);
            }
        }
        return bill;
    }

    private void resetValue(DynamicObject bill, Map<String, String> headMapInfo) {
        EntityType type = (EntityType)bill.getDataEntityType();
        for (Map.Entry<String, String> headMapentry : headMapInfo.entrySet()) {
            String key = headMapentry.getKey();
            String value = headMapentry.getValue();
            Object valueObj = null;
            IDataEntityProperty property = type.findProperty(key);
            if (property instanceof BasedataProp) {
                BasedataProp baseprop = (BasedataProp)property;
                valueObj = DynamicObjectUtil.buildObject(baseprop.getBaseEntityId(), Long.valueOf(value));
            } else {
                valueObj = property instanceof DecimalProp ? new BigDecimal(value) : (property instanceof DateTimeProp ? new Date(Long.parseLong(value)) : (property instanceof BooleanProp ? Boolean.valueOf(value) : value));
            }
            property.setValueFast((Object)bill, valueObj);
        }
    }
}

