/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.level;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.pricing.IPricing;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.PricingLang;
import kd.scmc.ism.model.bill.impl.AbstractCoupleSettleBillsModel;

public abstract class BasePriceLevelModel<T extends AbstractCoupleSettleBillsModel<?>> {
    public static final String TYPE_CUSTOMER = "customer";
    public static final String TYPE_SUPPLIER = "supplier";
    private Map<String, IPricing<T>> pricings = new HashMap<String, IPricing<T>>(16);
    private Map<Long, String[]> entryIdLvMap = null;
    private Map<Long, T> remainObjMap = null;
    private List<T> failEntry = new ArrayList<T>();
    private Map<String, List<T>> levelObjs = new HashMap<String, List<T>>(16);
    private Map<String, String> pricingKeyToName = new HashMap<String, String>(16);

    public void initPricingKeyMap(Map<String, String> keyMap) {
        this.pricingKeyToName.putAll(keyMap);
    }

    protected void initModel(Collection<T> models) {
        if (CommonUtils.collectionIsEmpty(models)) {
            return;
        }
        this.entryIdLvMap = new HashMap<Long, String[]>(models.size());
        this.remainObjMap = new HashMap<Long, T>(models.size());
        for (AbstractCoupleSettleBillsModel model : models) {
            if (!this.isPricing(model)) continue;
            Long entryId = model.getId();
            String[] levels = this.getLevels(model);
            this.entryIdLvMap.put(entryId, levels);
            this.remainObjMap.put(entryId, model);
        }
    }

    protected abstract boolean isPricing(T var1);

    protected abstract String[] getLevels(T var1);

    public final void bacthProcessing(ISMRequestContext context, Collection<T> models) {
        int size = this.getEnumSize();
        this.initModel(models);
        for (int i = 0; i < size; ++i) {
            this.levelObjs.clear();
            if (this.remainObjMap.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<Long, T>> it = this.remainObjMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, T> next = it.next();
                Long entryId = next.getKey();
                AbstractCoupleSettleBillsModel pricingModel = (AbstractCoupleSettleBillsModel)next.getValue();
                String[] levels = this.entryIdLvMap.get(entryId);
                if (levels == null || i >= levels.length) {
                    this.entryIdLvMap.remove(entryId);
                    this.failEntry.add(pricingModel);
                    it.remove();
                    continue;
                }
                String lv = levels[i];
                ArrayList<AbstractCoupleSettleBillsModel> entryList = this.levelObjs.get(lv);
                entryList = entryList == null ? new ArrayList<AbstractCoupleSettleBillsModel>(this.remainObjMap.size()) : entryList;
                entryList.add(pricingModel);
                this.levelObjs.put(lv, entryList);
            }
            if (CommonUtils.mapIsEmpty(this.levelObjs)) continue;
            Set<Long> successModelIds = this.assign4Entry(this.levelObjs, context);
            this.removeSuccessObj(successModelIds);
        }
    }

    private void removeSuccessObj(Set<Long> successModelIds) {
        if (CommonUtils.collectionIsEmpty(successModelIds)) {
            return;
        }
        Iterator<Map.Entry<Long, T>> iterator = this.remainObjMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, T> entry = iterator.next();
            Long modelId = entry.getKey();
            if (!successModelIds.contains(modelId)) continue;
            iterator.remove();
        }
    }

    protected Set<Long> assign4Entry(Map<String, List<T>> levelObjMap, ISMRequestContext context) {
        HashSet<Long> successIds = new HashSet<Long>();
        for (Map.Entry<String, List<T>> entrys : levelObjMap.entrySet()) {
            String key = entrys.getKey();
            List<T> value = entrys.getValue();
            IPricing<T> pricing = this.pricings.get(key);
            if (pricing == null) continue;
            key = this.transLang(key);
            try {
                Set<Long> successPriciedId = pricing.handlePricing(key, value, context);
                successIds.addAll(successPriciedId);
            }
            catch (Exception e) {
                for (AbstractCoupleSettleBillsModel model : value) {
                    String failReason = PricingLang.priceFail() + ':' + ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    context.getPricingLogHandler().logFailInfo(pricing.getPricingType(), model.getId(), key, failReason);
                }
            }
        }
        return successIds;
    }

    private String transLang(String key) {
        String keyLang = this.pricingKeyToName.get(key);
        if (StringUtils.isNotEmpty((CharSequence)keyLang)) {
            return keyLang;
        }
        return key;
    }

    protected int getEnumSize() {
        return this.pricings.size();
    }

    protected List<T> getFailEntry() {
        return this.failEntry;
    }

    protected Map<String, IPricing<T>> getPricings() {
        return this.pricings;
    }
}

