/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.level;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.consts.enums.CurrencySrcEnum;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.level.AbstractBillLevelModel;
import kd.scmc.ism.common.model.pricing.impl.currency.InCustomerCurrencyPricing;
import kd.scmc.ism.common.model.pricing.impl.currency.InSupplierCurrencyPricing;
import kd.scmc.ism.common.model.pricing.impl.currency.SettleDemCurrencyPricing;
import kd.scmc.ism.common.model.pricing.impl.currency.SettleSupCurrencyPricing;
import kd.scmc.ism.common.model.pricing.impl.currency.SpecifyCurrencyPricing;
import kd.scmc.ism.common.model.pricing.impl.currency.SrcBizBillCurrencyPricing;
import kd.scmc.ism.common.model.pricing.impl.currency.SrcOrderCurrencyPricing;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;

public class CurrencySrcLevelModel
extends AbstractBillLevelModel {
    public CurrencySrcLevelModel(ISMServiceContext serviceContext) {
        this.getPricings().put(CurrencySrcEnum.SUP_SETTLE_BASE.getValue(), new SettleSupCurrencyPricing(serviceContext));
        this.getPricings().put(CurrencySrcEnum.DEM_SETTLE_BASE.getValue(), new SettleDemCurrencyPricing(serviceContext));
        this.getPricings().put(CurrencySrcEnum.INTER_SUPPLIER.getValue(), new InSupplierCurrencyPricing(serviceContext));
        this.getPricings().put(CurrencySrcEnum.INTER_CUSTOMER.getValue(), new InCustomerCurrencyPricing(serviceContext));
        this.getPricings().put(CurrencySrcEnum.SPECIFY.getValue(), new SpecifyCurrencyPricing(serviceContext));
        this.getPricings().put(CurrencySrcEnum.SRC_ORDER.getValue(), new SrcOrderCurrencyPricing(serviceContext));
        this.getPricings().put(CurrencySrcEnum.SRC_BILL.getValue(), new SrcBizBillCurrencyPricing(serviceContext));
    }

    @Override
    protected String[] getLevels(CoupleSettleBillsModel model) {
        DynamicObject priceRule = model.getPriceRuleObj();
        DynamicObject priceRuleEntry = (DynamicObject)priceRule.getDynamicObjectCollection("entryentity").iterator().next();
        String settleSource = priceRuleEntry.getString("currencysource");
        return DynamicObjectUtil.parseMultiSelectText(settleSource);
    }
}

