/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.level;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.consts.enums.SettlePriceSrcEnum;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.level.AbstractEntryLevelModel;
import kd.scmc.ism.common.model.pricing.impl.price.CustomPlugInPricePricing;
import kd.scmc.ism.common.model.pricing.impl.price.NextPathPricing;
import kd.scmc.ism.common.model.pricing.impl.price.PreviousPathPricing;
import kd.scmc.ism.common.model.pricing.impl.price.SettleCostPricePricing;
import kd.scmc.ism.common.model.pricing.impl.price.SettlePurPolicyPricePricing;
import kd.scmc.ism.common.model.pricing.impl.price.SettleSalPolicyPricePricing;
import kd.scmc.ism.common.model.pricing.impl.price.SpecifyPricePricing;
import kd.scmc.ism.common.model.pricing.impl.price.SrcBillPricePricing;
import kd.scmc.ism.common.model.pricing.impl.price.SrcBillPricePricingByPrice;
import kd.scmc.ism.common.model.pricing.impl.price.SrcBillPricePricingByTaxPrice;
import kd.scmc.ism.common.model.pricing.impl.price.SrcOrderPricePricing;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public class SettlePriceSrcLevelModel
extends AbstractEntryLevelModel {
    public SettlePriceSrcLevelModel(ISMServiceContext serviceContext) {
        this.getPricings().put(SettlePriceSrcEnum.SETTLE_COST.getValue(), new SettleCostPricePricing(serviceContext));
        this.getPricings().put(SettlePriceSrcEnum.SETTLE_PURPOLICY.getValue(), new SettlePurPolicyPricePricing(serviceContext));
        this.getPricings().put(SettlePriceSrcEnum.SETTLE_SALPOLICY.getValue(), new SettleSalPolicyPricePricing(serviceContext));
        this.getPricings().put(SettlePriceSrcEnum.SRC_BILL.getValue(), new SrcBillPricePricing(serviceContext));
        this.getPricings().put("srcbillprice", new SrcBillPricePricingByPrice(serviceContext));
        this.getPricings().put("srcbilltaxprice", new SrcBillPricePricingByTaxPrice(serviceContext));
        this.getPricings().put(SettlePriceSrcEnum.SRC_ORDER.getValue(), new SrcOrderPricePricing(serviceContext));
        this.getPricings().put(SettlePriceSrcEnum.SPECIFY.getValue(), new SpecifyPricePricing(serviceContext));
        this.getPricings().put(SettlePriceSrcEnum.PLUGIN_CUSTOM.getValue(), CustomPlugInPricePricing.build(serviceContext));
        this.getPricings().put("pre", new PreviousPathPricing(serviceContext));
        this.getPricings().put("nxt", new NextPathPricing(serviceContext));
    }

    @Override
    protected String[] getLevels(CoupleSettleBillEntriesModel model) {
        DynamicObject priceRuleEntry = model.getPriceRuleEntryObj();
        String settleSource = priceRuleEntry.getString("settlesource");
        return DynamicObjectUtil.parseMultiSelectText(settleSource);
    }
}

