/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.level;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.consts.enums.TaxSrcEnum;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.level.AbstractEntryLevelModel;
import kd.scmc.ism.common.model.pricing.impl.taxrate.InCustomerTaxRatePricing;
import kd.scmc.ism.common.model.pricing.impl.taxrate.InSupplierTaxRatePricing;
import kd.scmc.ism.common.model.pricing.impl.taxrate.MaterialTaxRatePricing;
import kd.scmc.ism.common.model.pricing.impl.taxrate.PurPolicyTaxRatePricing;
import kd.scmc.ism.common.model.pricing.impl.taxrate.SalPolicyTaxRatePricing;
import kd.scmc.ism.common.model.pricing.impl.taxrate.SpecifyTaxRatePricing;
import kd.scmc.ism.common.model.pricing.impl.taxrate.SrcBillTaxRatePricing;
import kd.scmc.ism.common.model.pricing.impl.taxrate.SrcOrderTaxRatePricing;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;

public class TaxSrcLevelModel
extends AbstractEntryLevelModel {
    public TaxSrcLevelModel(ISMServiceContext serviceContext) {
        this.getPricings().put(TaxSrcEnum.INTER_CUSTOMER.getValue(), new InCustomerTaxRatePricing(serviceContext));
        this.getPricings().put(TaxSrcEnum.INTER_SUPPLIER.getValue(), new InSupplierTaxRatePricing(serviceContext));
        this.getPricings().put(TaxSrcEnum.PUR_PRICEPOLICY.getValue(), new PurPolicyTaxRatePricing(serviceContext));
        this.getPricings().put(TaxSrcEnum.SAL_PRICEPOLICY.getValue(), new SalPolicyTaxRatePricing(serviceContext));
        this.getPricings().put(TaxSrcEnum.SPECIFY.getValue(), new SpecifyTaxRatePricing(serviceContext));
        this.getPricings().put(TaxSrcEnum.SRC_BILL.getValue(), new SrcBillTaxRatePricing(serviceContext));
        this.getPricings().put(TaxSrcEnum.SRC_ORDER.getValue(), new SrcOrderTaxRatePricing(serviceContext));
        this.getPricings().put(TaxSrcEnum.MATERIAL.getValue(), new MaterialTaxRatePricing(serviceContext));
    }

    @Override
    protected String[] getLevels(CoupleSettleBillEntriesModel model) {
        DynamicObject priceRuleEntry = model.getPriceRuleEntryObj();
        String settleSource = priceRuleEntry.getString("taxsource");
        return DynamicObjectUtil.parseMultiSelectText(settleSource);
    }
}

