/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.ism.common.utils.CommonUtils;

public class PricingTypeLogHandler {
    private final String logtype;
    private Map<Long, String> successInfo = new HashMap<Long, String>();
    private Map<Long, Object> result = new HashMap<Long, Object>();
    private Map<Long, List<String>> logInfos = new HashMap<Long, List<String>>();

    PricingTypeLogHandler(String logtype) {
        this.logtype = logtype;
    }

    public String getLogtype() {
        return this.logtype;
    }

    public void logFailInfo(long modelId, String pricingkey, String failReason) {
        StringBuilder info = new StringBuilder();
        info.append(pricingkey).append(' ').append(ResManager.loadKDString((String)"\u3010\u5931\u8d25\u3011", (String)"FailMark", (String)"scmc-ism-form", (Object[])new Object[0])).append(':').append(failReason);
        this.logInfo(modelId, info.toString());
    }

    public void logSuccessInfo(long modelId, String pricingkey, Object value) {
        this.successInfo.put(modelId, pricingkey);
        this.result.put(modelId, value);
    }

    private void logInfo(long modelId, String info) {
        List<String> infos = this.logInfos.get(modelId);
        if (infos == null) {
            infos = new ArrayList<String>();
            this.logInfos.put(modelId, infos);
        }
        infos.add(info);
    }

    public Map<Long, Object> getResult() {
        return this.result;
    }

    public Map<Long, List<String>> getLogInfos() {
        HashMap<Long, List<String>> maps = new HashMap<Long, List<String>>();
        for (Map.Entry<Long, List<String>> entry : this.logInfos.entrySet()) {
            CommonUtils.mapGetListValue(maps, entry.getKey()).addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Long, Object> entry : this.successInfo.entrySet()) {
            Long entryId = entry.getKey();
            String successKey = (String)entry.getValue();
            StringBuilder info = new StringBuilder();
            info.append(successKey).append(' ').append(ResManager.loadKDString((String)"\u3010\u6210\u529f\u3011", (String)"SuccessMark", (String)"scmc-ism-form", (Object[])new Object[0]));
            CommonUtils.mapGetListValue(maps, entryId).add(info.toString());
        }
        return maps;
    }

    public void markSucceededFail(long modelId, String failReason) {
        String pricingkey = this.successInfo.remove(modelId);
        this.logFailInfo(modelId, pricingkey, failReason);
    }

    public String getLogInfo() {
        return this.logInfos.toString();
    }
}

