/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.log;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.args.GenerateBillArgs;
import kd.scmc.ism.common.model.args.GenerateResult;
import kd.scmc.ism.common.model.entity.BillExecSequence;
import kd.scmc.ism.common.model.entity.BillExecuteInfo;
import kd.scmc.ism.common.model.mapper.DynamicObjectCacheMapper;
import kd.scmc.ism.common.result.BatchBillOpResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.common.utils.SettleLogUtils;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.relation.AbstractRelationModel;
import kd.scmc.ism.model.relation.RelationEntryModel;

public class SettleLogHandler {
    private static final Log logger = LogFactory.getLog(SettleLogHandler.class);
    private BillExecSequence sequence = new BillExecSequence();
    private DynamicObject logInfo = null;

    public static SettleLogHandler build(SettleBillModel bill) {
        SettleLogHandler logHandler = new SettleLogHandler();
        logHandler.initLog(bill);
        return logHandler;
    }

    public static SettleLogHandler load(DynamicObject settleLogObj) {
        SettleLogHandler logHandler = new SettleLogHandler();
        BillExecSequence sequence = logHandler.getSequence();
        sequence.setBizTraceNo(settleLogObj.getString("biztraceno"));
        DynamicObjectCollection logEntries = settleLogObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject logEntry : logEntries) {
            String groupKey = logEntry.getString("groupkey");
            Long billId = logEntry.getLong("settlebillid");
            if (CommonUtils.idIsNull(billId)) continue;
            String entityType = logEntry.getDynamicObject("settlebilltype").getString("number");
            String billNo = logEntry.getString("settlebillno");
            BillExecuteInfo billExecuteInfo = new BillExecuteInfo(entityType, billId, logEntry.getDynamicObject("bizflow"));
            billExecuteInfo.setBillNo(billNo);
            sequence.addExecInfo(groupKey, billExecuteInfo);
        }
        logHandler.logInfo = settleLogObj;
        return logHandler;
    }

    private SettleLogHandler() {
    }

    private void initLog(SettleBillModel bill) {
        DynamicObject dataLog = this.getDataLog();
        dataLog.set("sourceid", (Object)bill.getId());
        dataLog.set("sourcenum", bill.getObj().get("billno"));
        dataLog.set("sourcetype", (Object)bill.getBillEntityType());
        Date curDate = new Date();
        dataLog.set("createdate", (Object)curDate);
        dataLog.set("editdate", (Object)curDate);
    }

    public void logNoGenInfo(Collection<AbstractRelationModel> relModels) {
        this.getDataLog().set("createstatus", (Object)"N");
        for (AbstractRelationModel relModel : relModels) {
            for (RelationEntryModel entryModel : relModel.getRelationEntries()) {
                HashMap<String, Object> map = new HashMap<String, Object>(64);
                map.put("settledate", new Date());
                map.put("esupsettleorg", entryModel.getSupplierId());
                map.put("edemandorg", entryModel.getDemandId());
                map.put("supsettleorg", relModel.getSupplierId());
                map.put("oppositeorg", relModel.getDemandId());
                map.put("settlerelation", relModel.getRelationObj().getPkValue());
                map.put("groupkey", relModel.getKey());
                map.put("iscreat", Boolean.FALSE);
                map.put("billstatus", "0");
                map.put("relationtype", "other");
                this.addLogEntry(map);
            }
        }
    }

    public void logInfo(AbstractRelationModel relModel, GenerateBillArgs genArgs, GenerateResult result) {
        if (relModel == null || result == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(64);
        map.put("settledate", new Date());
        map.put("settlebilltype", result.getBillType());
        map.put("botpid", result.getBotpid());
        map.put("bizflow", result.getBizFlow());
        map.put("supsettleorg", relModel.getSupplierId());
        map.put("oppositeorg", relModel.getDemandId());
        map.put("settlerelation", relModel.getRelationObj().getPkValue());
        map.put("groupkey", relModel.getKey());
        DynamicObject entrySettlerelation = genArgs.getEntrySettlerelation();
        if (entrySettlerelation != null) {
            map.put("settlepath", entrySettlerelation.getPkValue());
            if (relModel.getRelationObj().getBoolean("isdynapath")) {
                map.put("esupsettleorg", relModel.getSupplierId());
                map.put("edemandorg", relModel.getDemandId());
            } else {
                DynamicObject supplier = entrySettlerelation.getDynamicObject("supplier");
                DynamicObject demand = entrySettlerelation.getDynamicObject("demand");
                map.put("esupsettleorg", DynamicObjectUtil.getPkValue(supplier));
                map.put("edemandorg", DynamicObjectUtil.getPkValue(demand));
            }
        }
        map.put("relationtype", genArgs.getGenType());
        if (result.isSuccess()) {
            SettleBillModel genbillModel = result.getBill();
            map.put("iscreat", Boolean.TRUE);
            map.put("billstatus", "1");
            map.put("settlebillid", genbillModel.getId());
            map.put("settlebilltype", genbillModel.getBillEntityType());
            map.put("groupnumber", genbillModel.getValue("groupnumber"));
            DynamicObject bill = genbillModel.getObj();
            map.put("settlebillno", bill.get("billno"));
            BillExecuteInfo info = new BillExecuteInfo(genbillModel, result.getBizFlow());
            this.sequence.addExecInfo(relModel.getKey(), info);
            info.setBillNo(bill.getString("billno"));
        } else {
            map.put("iscreat", Boolean.FALSE);
            map.put("billstatus", "0");
            map.put("failcause", result.getFailReason());
        }
        this.addLogEntry(map);
    }

    private void addLogEntry(Map<String, Object> logEntry) {
        if (logEntry == null) {
            return;
        }
        logger.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97-\u65e5\u5fd7\u8bb0\u5f55\u5355\u636e\u751f\u6210\u4fe1\u606f\uff1a" + logEntry);
        DynamicObjectCollection logInfoEntry = this.getDataLogInfo();
        DynamicObject settleLogInfo = logInfoEntry.addNew();
        settleLogInfo.set("seq", (Object)logInfoEntry.size());
        for (Map.Entry<String, Object> entry : logEntry.entrySet()) {
            settleLogInfo.set(entry.getKey(), entry.getValue());
        }
    }

    public void updateSettleBillStatus(BatchBillOpResult positiveExecute) {
        Map<Long, String> statusInfo = positiveExecute.getBillStatusInfo();
        for (DynamicObject logEntry : this.getDataLogInfo()) {
            long settleBillId = logEntry.getLong("settlebillid");
            logEntry.set("billstatus", (Object)SettleLogUtils.tansferToLogStatus(statusInfo.get(settleBillId)));
            String failReason = positiveExecute.getFailReasonInfo().get(settleBillId);
            if (!StringUtils.isNotEmpty((CharSequence)failReason)) continue;
            logEntry.set("failcause", (Object)SettleLogUtils.entryErroMsgCutDown(failReason));
            this.getDataLog().set("createstatus", (Object)"B");
        }
    }

    public DynamicObject preSaveLog(ISMServiceContext serviceContext) {
        DynamicObject dataLog = this.getDataLog();
        int actualCount = 0;
        boolean isAllCreate = true;
        for (DynamicObject singledata : this.getDataLogInfo()) {
            Object supOrg = singledata.get("esupsettleorg");
            Object demOrg = singledata.get("edemandorg");
            if (supOrg != null && demOrg != null && supOrg instanceof Long && demOrg instanceof Long) {
                DynamicObjectCacheMapper service = serviceContext.getService(DynamicObjectCacheMapper.class);
                DynamicObject supplier = service.get("bos_org", supOrg);
                DynamicObject demand = service.get("bos_org", demOrg);
                String path = (supplier != null ? supplier.getString("name") : null) + " -> " + (demand != null ? demand.getString("name") : null);
                singledata.set("settlepathtext", (Object)path);
            }
            if (singledata.getBoolean("iscreat")) {
                ++actualCount;
                continue;
            }
            isAllCreate = false;
        }
        String createStatus = dataLog.getString("createstatus");
        if (isAllCreate && actualCount > 0) {
            dataLog.set("createstatus", (Object)"W");
        } else if (!"U".equals(createStatus) && !"N".equals(createStatus)) {
            dataLog.set("createstatus", (Object)"C");
        }
        dataLog.set("shouldcount", (Object)this.getDataLogInfo().size());
        dataLog.set("actualcount", (Object)actualCount);
        return dataLog;
    }

    public void setMatchFail(String reason) {
        this.getDataLog().set("createstatus", (Object)"U");
        this.getDataLog().set("billfailcause", (Object)SettleLogUtils.headErroMsgCutDown(reason));
    }

    public void setSettleReason(String reason) {
        this.getDataLog().set("billfailcause", (Object)SettleLogUtils.headErroMsgCutDown(reason));
    }

    public boolean isSuccessGenerateAllBills() {
        if (this.getDataLogInfo() == null || this.getDataLogInfo().size() == 0) {
            return false;
        }
        Boolean isAllCreate = Boolean.TRUE;
        for (DynamicObject singleDataLogInfo : this.getDataLogInfo()) {
            Boolean isCreate = singleDataLogInfo.getBoolean("iscreat");
            if (isCreate.booleanValue()) continue;
            isAllCreate = Boolean.FALSE;
            break;
        }
        return isAllCreate;
    }

    public BillExecSequence getSequence() {
        return this.sequence;
    }

    public DynamicObject getDataLog() {
        if (this.logInfo == null) {
            this.logInfo = BusinessDataServiceHelper.newDynamicObject((String)"ism_settlelog");
            this.logInfo.set("id", (Object)DB.genLongId((String)"ism_settlelog"));
        }
        return this.logInfo;
    }

    public DynamicObjectCollection getDataLogInfo() {
        return this.getDataLog().getDynamicObjectCollection("entryentity");
    }

    public void setBizTraceNo(String biztraceno) {
        this.getDataLog().set("biztraceno", (Object)biztraceno);
        this.sequence.setBizTraceNo(biztraceno);
    }
}

