/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.common.model.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractMapper<K, V> {
    protected Map<K, V> map = new HashMap();

    public void load(K ... objects) {
        HashSet<K> sets = new HashSet<K>(objects.length);
        for (K object : objects) {
            sets.add(object);
        }
        this.load((Collection<K>)sets);
    }

    public void load(Collection<K> objects) {
        HashSet<K> needQueryKey = new HashSet<K>();
        for (K obj : objects) {
            if (obj == null || this.map.containsKey(obj)) continue;
            needQueryKey.add(obj);
        }
        if (needQueryKey.size() != 0) {
            this.handle(needQueryKey);
        }
    }

    protected abstract List<V> handle(Collection<K> var1);

    public V get(K obj) {
        if (obj == null) {
            return null;
        }
        if (!this.map.containsKey(obj)) {
            ArrayList<K> array = new ArrayList<K>();
            array.add(obj);
            this.handle(array);
        }
        return this.map.get(obj);
    }
}

